#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
package Mubot4FB::Tweet;

use strict;
use utf8;

use Net::Twitter::Lite;
use Encode;

use Data::Dumper;

use base 'Mubot4FB::Common';

sub init {
	my ($me) = @_;

	$me->{twitter} = Net::Twitter::Lite->new(consumer_key => $me->{cfg}->{twitter}->{consumer_key},
						 consumer_secret => $me->{cfg}->{twitter}->{consumer_secret},
						 legacy_list_api => 0);

	$me->{twitter}->access_token($me->{cfg}->{twitter}->{access_token});
	$me->{twitter}->access_token_secret($me->{cfg}->{twitter}->{access_secret});

	return $me->{twitter};
}

sub publish {
	my ($me, $text, $uri, $in_reply_to) = @_;

	$text = substr($text, 0, 110) . '...' if (length($text) > 110);

	my $o = {status => $text . ' ' . $uri};
	$o->{in_reply_to_status_id} = $in_reply_to if (defined $in_reply_to);

	my $status;
	eval {$status = $me->{twitter}->update($o)};
	return $status;
}

sub remove {
	my ($me, $tweet_id) = @_;
	my $status;
	eval {$status = $me->{twitter}->destroy_status($tweet_id)};
	return $status;
}

1;
