#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
package Mubot4FB::Queue::Worker;
use strict;
use utf8;

use base 'Jonk::Worker';

use JSON::XS;

use Data::Dumper;

sub new {
	my ($class, $cfg, $dbh, $opts) = @_;
	my $self = $class->SUPER::new($dbh, $opts);
	$self->{cfg} = $cfg;

	$self->{find_job_query} = sprintf('SELECT * FROM %s WHERE func IN (%s) AND enqueue_time < NOW() - INTERVAL %s SECOND ORDER BY id LIMIT %s',
					  ($opts->{table_name}||'job'),
					  join(', ', map { "'$_'" } @{$opts->{functions}}),
					  ($opts->{find_delay}||60),
					  ($opts->{job_find_size}||50),
	    );
	bless $self, $class;
	return $self;
}

sub dequeue {
	my ($me) = @_;
	my $job = $me->SUPER::dequeue;
	$job->{arg} = decode_json($job->{arg}) if defined $job && defined $job->{arg};
	return $job;
}

1;
