#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
package Mubot4FB::DB::Tweet;
use strict;
use utf8;

use base 'Mubot4FB::DB';

use Data::Dumper;

sub add_map {
	my ($me, $db_args) = @_;
	my $sth = $me->{dbh}->prepare("insert into tweet_map (key_id, tweet_id, user_id, screen_name) VALUES (?,?,?,?)");
	$sth->bind_param(1, $db_args->{key_id}, SQL_BIGINT);
	$sth->bind_param(2, $db_args->{tweet_id}, SQL_BIGINT);
	$sth->bind_param(3, $db_args->{user_id}, SQL_BIGINT);
	$sth->bind_param(4, $db_args->{screen_name}, SQL_VARCHAR);
	my $rv = $sth->execute();
	$sth->finish;
	return $rv;
}

sub search_by_key_id {
	my ($me, $db_args) = @_;
	my $sth = $me->{dbh}->prepare("select * from tweet_map where key_id = ?");
	my $rv = $sth->execute();

	my $ret = $sth->fetchrow_hashref();
	$sth->finish;

	return $ret;
}

sub delete_map_by_tweet_id {
	my ($me, $db_args) = @_;
	my $sth = $me->{dbh}->prepare("delete from tweet_map where tweet_id = ?");
	$sth->bind_param(1, $db_args->{tweet_id}, SQL_BIGINT);

	my $rv = $sth->execute();
	$sth->finish;
	return $rv;
}

sub delete_map_by_key_id {
	my ($me, $db_args) = @_;
	my $sth = $me->{dbh}->prepare("delete from tweet_map where key_id = ?");
	$sth->bind_param(1, $db_args->{key_id}, SQL_BIGINT);

	my $rv = $sth->execute();
	$sth->finish;
	return $rv;
}
