#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
package Mubot4FB::DB;
use strict;
use utf8;

use DBI qw/:sql_types/;

use Data::Dumper;

sub new {
	my $proto = shift;
	my $class = ref $proto || $proto;
	my $self = {cfg => shift};
	bless $self, $class;

	$self->init();
	return $self;
}

sub init {
	my ($me) = @_;
	return $me->{dbh} = DBI->connect('DBI:mysql:'.$me->{cfg}->{database}, $me->{cfg}->{db_user}, $me->{cfg}->{db_pass},{mysql_enable_utf8 => 1, mysql_auto_reconnect => 1}) || die $DBI::errstr;
}

sub check_dup {
	my ($me, $db_args) = @_;
	my $sth = $me->{dbh}->prepare('select * from posts where uri = ? order by post_time desc limit 1');
	my $rv = $sth->execute($db_args->{uri});
	my $ret = $sth->fetchrow_hashref;

	$sth->finish;
	return $ret;
}

sub add {
	my ($me, $db_args) = @_;

	my ($scheme, $path) = split(/:\/\//, $db_args->{uri});
	my $sth = $me->{dbh}->prepare("insert into posts (submitter, fb_post_id, uri, prefix, comment, scheme, path, post_time) values (?, ?, ?, ?, ?, ?, ?, ?)");
	$sth->bind_param(1, $db_args->{submitter}, SQL_VARCHAR);
	$sth->bind_param(2, $db_args->{fb_post_id}, SQL_BIGINT);
	$sth->bind_param(3, $db_args->{uri}, SQL_VARCHAR);
	$sth->bind_param(4, $db_args->{prefix}, SQL_VARCHAR);
	$sth->bind_param(5, $db_args->{comment}, SQL_VARCHAR);
	$sth->bind_param(6, $scheme, SQL_VARCHAR);
	$sth->bind_param(7, $path, SQL_VARCHAR);
	$sth->bind_param(8, time, SQL_BIGINT);
	my $rv = $sth->execute();
	$sth->finish;

	return $rv;
}

sub remove {
	my ($me, $db_args) = @_;
	$db_args->{submitter_type} ||= 1;

	my $sth = $me->{dbh}->prepare("delete from posts where fb_post_id = ? and submitter = ? and submitter_type = ?");

	$sth->bind_param(1, $db_args->{fb_post_id}, SQL_BIGINT);
	$sth->bind_param(2, $db_args->{submitter}, SQL_VARCHAR);
	$sth->bind_param(3, $db_args->{submitter_type}, SQL_INTEGER);
	my $rv = $sth->execute();
	my $ret = $rv ? $sth->rows : 0;

	$sth->finish;

	return $ret;
}

sub search_by_word {
	my ($me, $db_args) = @_;

	my $column = $db_args->{word} =~ /:\/\// ? 'uri' : 'path';
	my $w = '%' . $db_args->{word} . '%';
	my $sth = $me->{dbh}->prepare('select * from posts where prefix like ? or '.$column.' like ? or comment like ? order by post_time desc limit 1000');
	$sth->bind_param(1, $w, SQL_VARCHAR);
	$sth->bind_param(2, $w, SQL_VARCHAR);
	$sth->bind_param(3, $w, SQL_VARCHAR);
	$sth->execute();

	my $ret = $sth->fetchall_arrayref({});
	$sth->finish;

	return $ret;
}

sub search_by_fb_post_id {
	my ($me, $db_args) = @_;

	my $sth = $me->{dbh}->prepare('select * from posts where fb_post_id = ?');
	$sth->bind_param(1, $db_args->{fb_post_id}, SQL_BIGINT);
	$sth->execute();
	my $ret = $sth->fetchrow_hashref();
	$sth->finish;

	return $ret;
}

sub search_lastpost_by_submitter {
	my ($me, $db_args) = @_;

	my $sth = $me->{dbh}->prepare('select * from posts where submitter = ? order by post_time desc limit 1');
	$sth->bind_param(1, $db_args->{who}, SQL_VARCHAR);
	$sth->execute();

	my $ret = $sth->fetchrow_hashref();
	$sth->finish;

	return $ret;
}

sub bulkget_latest {
	my ($me, $db_args) = @_;
	my $limit = defined $db_args->{limit} ? $db_args->{limit} : 100;

	my $sth = $me->{dbh}->prepare('select * from posts order by post_time desc limit ?');
	$sth->bind_param(1, $limit, SQL_INTEGER);
	$sth->execute();

	my $ret = $sth->fetchall_arrayref({});
	$sth->finish;
	return $ret;
}

sub commit {
	my ($me) = @_;
	$me->{dbh}->commit;
}

sub rollback {
	my ($me) = @_;
	$me->{dbh}->rollback;
}

sub begin {
	my ($me) = @_;
	$me->{dbh}->begin_work;
}

1;
