/****************************************************************
  Copyright(C) 2006-2014 Eisai Co., Ltd. All rights reserved.
-----------------------------------------------------------------
    @addtogroup Refine_Thoto_Points
    @file       XYPoint.hpp
	@brief      X,Y ֐̎
	@date       2012.12.12
	@author     M.Fukuda@Eisai
	@version    1.2.0
	@note
****************************************************************/
#pragma once

#include "XYPoint_Def.hpp"
/* ------ TYPEDEF Infomations --------------------------- /
const XYP_ NG_XYP(-1.0,-1.0);

-- RFN::XYP --
ELM  XYP       --- std::pair<double,double>
     vXYP      --- std::vector<XYP>
ITR  vXYP_Itr  --- vXYP::iterator
	 vXYP_cItr --- vXYP::const_iterator
SPTR vXYP_sp   --- vXYP*
/ -------------------------------------------------------*/
#include <algorithm>
#include <tuple>     // for std::tie

#include "../Standardinline.hpp"

namespace RFN {
namespace XYP {

// ---------------------------------------------------------
// ֐IuWFNg
// --------------------------------------------------------

//// $$$ gpӏ#2014.01.22
//// Ỹ\[g֐IuWFNg
//struct lessY : public std::binary_function<const RFN::XYP::XYP_&, const RFN::XYP::XYP_&, bool> {
//	bool operator()(const RFN::XYP::XYP_& lxyp, const RFN::XYP::XYP_& rxyp) const {
//		return lxyp.second < rxyp.second;
//	}
//};

// binary sort pX֐IuWFNg
struct compX { 
	bool operator()(const RFN::XYP::XYP_& lxy, double rx)  { return lxy.first < rx; }
	bool operator()(double lx, const RFN::XYP::XYP_& rxy) { return lx < rxy.first; }
	bool operator()(const RFN::XYP::XYP_& lxy, const RFN::XYP::XYP_& rxy) { return lxy.first < rxy.first; }
};

//// $$$ gpӏ#2014.01.22
//// Zeroȉ̃|CgT
struct underZeroY : public std::unary_function<const RFN::XYP::XYP_&, bool> {
	bool operator()(const RFN::XYP::XYP_& tgt) const {
		return tgt.second < 0.0;
	}
};

// ---------------------------------------------------------
// 
// ---------------------------------------------------------

//// $$$ gpӏ#2014.01.22
//// vXYP ̗](Capacity)
//inline void shrinkToFit(RFN::XYP::vXYP_& vxyp) {
//	ELM::vXYP(vxyp).swap(vxyp);
//}

//// $$$ gpӏ#2014.01.22
//// vXYP SɃNA
//inline void fullClear(RFN::XYP::vXYP_& vxyp) {
//	vxyp.clear();
//	shrinkToFit(vxyp);
//}

// vxyp Ɂ@|Cgǉ
inline void addXYPoint(const double& x, const double& y, RFN::XYP::vXYP_& vxyp) {
	vxyp.push_back(std::make_pair(x, y));
}

//// $$$ gpӏ#2014.01.22
//// őIntensity XYP@ʒũCe[^Ԃ
//inline RFN::XYP::vXYP_::iterator getXYP_MaxIntensity(RFN::XYP::vXYP_& vxyp){
//	return std::max_element(vxyp.begin(), vxyp.end(), RFN::XYP::lessY());
//}

// vxyp̒ߎl x <= result.x łlTBꍇ vxyp
inline const RFN::XYP::vXYP_::iterator nearSearchX(
	const double& x, RFN::XYP::vXYP_& vxyp
) {
	return std::lower_bound(vxyp.begin(), vxyp.end(), x, RFN::XYP::compX());
}

// Ce[^̒TŒ肵āi{͌vZĊm肵Ă̂]܂j
inline const RFN::XYP::vXYP_::iterator nearSearchX(const double& x, const ITR::vXYP_Itr& bit, RFN::XYP::vXYP_& vxyp) {
	return std::lower_bound(bit, vxyp.end(), x, RFN::XYP::compX());
}

//// $$$ gpӏ#2014.01.22
//inline const bool onInDistance(
//	const ITR::vXYP_Itr& bgnit,
//	const ITR::vXYP_Itr& endit,
//	const unsigned int lenRange
//){
//	if(lenRange == 0) return false;
//	return (std::distance(bgnit,endit) > static_cast<int>(lenRange));
//}

//// $$$ gpӏ#2014.01.22
//// Ce[^̒TŒ肵āi{͌vZĊm肵Ă̂]܂j
//inline const RFN::XYP::vXYP_::iterator nearSearchX_withABSRange(
//	const double& x, 
//	const ITR::vXYP_Itr& bit,
//	const unsigned int lenRange,
//	RFN::XYP::vXYP_& vxyp
//) {
//	if (onInDistance(bit, vxyp.end(), lenRange)) {
//		return std::lower_bound(bit, bit + lenRange, x, RFN::XYP::compX());
//	}
//	return std::lower_bound(bit, vxyp.end(), x, RFN::XYP::compX());
//}

//// $$$ gpӏ#2014.01.22
//// őIntensityԂ
//inline double getMaxIntensity(RFN::XYP::vXYP_& vxyp) {
//	return (*RFN::XYP::getXYP_MaxIntensity(vxyp)).second;
//}

// X, Y ̗vf̏ZԂ (product)
inline double productXY(const RFN::XYP::XYP_& src) {
	return src.first * src.second;
}

// Sort X 
inline void sortX(RFN::XYP::vXYP_& vxyp, const bool desc) {
	if (!desc) {
		std::sort(vxyp.begin(), vxyp.end());
	} else { // ~Ȃ̂ŃlQ[^Ŕ]
		std::sort(vxyp.begin(), vxyp.end(), std::greater<RFN::XYP::XYP_>());
	}
}

//// $$$ gpӏ#2014.01.22
//// Sort Y
//inline void sortY(RFN::XYP::vXYP_& vxyp, const bool desc) {
//	if (!desc) {
//		std::sort(vxyp.begin(), vxyp.end(), RFN::XYP::lessY());
//	} else { // ~Ȃ̂ŃlQ[^Ŕ]
//		std::sort(vxyp.begin(), vxyp.end(), std::not2(RFN::XYP::lessY()));
//	}
//}

// vxyp  minX, maxX͈̔͂Ce[^TB
// [Error] : litr = vxyp.end()
// Ex) minX < vxyp[0].mz ł΁Avxyp.begin()ԂB 
inline const std::pair<ITR::vXYP_Itr, ITR::vXYP_Itr>
	searchX_MinMax(
	const double& minX, 
	const double& maxX, 
	RFN::XYP::vXYP_& vxyp
) {
	// ftHgݒ肷
	ITR::vXYP_Itr lowit = vxyp.end(); // ÖׁAlowitEndɌŒB
	ITR::vXYP_Itr highit = vxyp.end();

	if (! vxyp.empty() && vxyp[0].first <= maxX) {
		// minX, maxX̐𔻒肷
		size_t num = vxyp.size();
		const double arrlow(vxyp[0].first), arrhigh(vxyp[num-1].first);

		if (minX < arrlow) { // z̍ŏlłΐ擪ԂB
			lowit = vxyp.begin();
		} else if (RFN::STD::eq_less(minX, arrhigh)) {
			lowit = nearSearchX(minX, vxyp);
		}
		if (maxX < 0.0 || arrhigh < maxX) { // wAz傫ꍇ͖[Ԃ
			highit = vxyp.end();
		} else if (RFN::STD::eq_less(arrlow, maxX)) {
			highit = nearSearchX(maxX, lowit, vxyp);
		}
	}
	return std::make_pair(lowit, highit);
}

//// $$$ gpӏ#2014.01.22
//// xeXgBmake_paiŕEE
//inline const bool
//	searchX_MinMaxF(const double& minX, const double& maxX, RFN::XYP::vXYP_& vxyp, ITR::vXYP_Itr& lowit, ITR::vXYP_Itr& highit) {
//	// ftHgݒ肷
//	lowit = vxyp.end(); // ÖׁAlowitEndɌŒB
//	highit = vxyp.end();
//
//	size_t num = vxyp.size();
//	const double arrlow(vxyp[0].first), arrhigh(vxyp[num-1].first);
//
//	if (minX < arrlow) { // z̍ŏlłΐ擪ԂB
//		lowit = vxyp.begin();
//	} else if (RFN::STD::eq_less(minX, arrhigh)) {
//		lowit = nearSearchX(minX, vxyp);
//	}
//	if (maxX < 0.0 || arrhigh < maxX) { // wAz傫ꍇ͖[Ԃ
//		highit = vxyp.end();
//	} else if (RFN::STD::eq_less(arrlow, maxX)) {
//		highit = nearSearchX_withABSRange(maxX, lowit, 63, vxyp);
//	}
//	return lowit != vxyp.end();
//}


// src ́@lx - rx ́@f[^ dst ɃRs[
// [in]  lx  : ŏl (minMz)
// [in]  rx  : ől (maxMz)
// [in]  src : ƂȂ vxyp
// [out] dst : ʂ̏o
// lȂuvŋA
inline bool getInRangeElements(
	const double& lx, const double& rx, 
	RFN::XYP::vXYP_& src, RFN::XYP::vXYP_& dst
){
	ITR::vXYP_Itr lit, rit;
	std::tie(lit, rit) = searchX_MinMax(lx, rx, src);

	dst.clear();
	// error. Break.
	if (lit == src.end()) { return false; }

	dst.reserve(std::distance(lit, rit));
	while(lit != rit) {
		dst.push_back(*lit);
		++lit;
	}
	return true;
}

// src@́@lx-rx@́@total Intensity (TIC) Ԃ
// [in]  lx  : ŏl (minMz)
// [in]  rx  : ől (maxMz)
// [in]  src : ƂȂ vxyp
// [rst] TIC or 0 (AG[͑S 0 )
inline const double getInRangeTotalIntensity(
	const double lx, const double rx, RFN::XYP::vXYP_& src
){
	ITR::vXYP_Itr lit, rit;
	std::tie(lit, rit) = searchX_MinMax(lx, rx, src);
//	searchX_MinMaxF(lx, rx, src, lit, rit);
	//ITR::vXYP_Itr lit = nearSearchX(lx, src);
	//ITR::vXYP_Itr rit = nearSearchX(rx, src);

	register double rstVal(0.0);
	if (lit != src.end()) {
		while(lit != rit) {
			rstVal += lit->second;
			++lit;
		}
	}
	return rstVal;
}

//// $$$ gpӏ#2014.01.22
inline const double getInRangeTotalIntensity(
	const double lx, const double rx, RFN::XYP::vXYP_& src, double rt, std::vector<std::tuple<double, double, double>>& vPnt
) {
	ITR::vXYP_Itr lit, rit;
	std::tie(lit, rit) = searchX_MinMax(lx, rx, src);
//	searchX_MinMaxF(lx, rx, src, lit, rit);
	//ITR::vXYP_Itr lit = nearSearchX(lx, src);
	//ITR::vXYP_Itr rit = nearSearchX(rx, src);

	register double rstVal(0.0);
	if (lit != src.end()) {
		while(lit != rit) {
			rstVal += lit->second;
			vPnt.push_back(std::tuple<double, double, double>(rt, lit->first, lit->second));
			++lit;
		}
	}
	return rstVal;
}

//// $$$ gpӏ#2014.01.22
//// src@́@lx-rx@́@Max Intensity Ԃ
//// [in]  lx  : ŏl (minMz)
//// [in]  rx  : ől (maxMz)
//// [in]  src : ƂȂ vxyp
//// [rst] Max Intensity or 0 (AG[͑S 0 )
//inline const double getInRangeMaxIntensity(
//	const double& lx, const double& rx, RFN::XYP::vXYP_& src
//){
//	ITR::vXYP_Itr lit, rit;
//	std::tie(lit, rit) = searchX_MinMax(lx, rx, src);
//
//	double rstVal(0.0);
//	if (lit != src.end()) {
//		while(lit != rit) {
//			rstVal = (RFN::STD::eq_less(rstVal, lit->second)) ? lit->second : rstVal;
//			++lit;
//		}
//	}
//	return rstVal;
//}

//// $$$ gpӏ#2014.01.22
//// src̎wԂY(Intensity)SĂOɂB
//inline void clearY(
//	const double& lx, const double& rx, RFN::XYP::vXYP_& src
//) {
//	ITR::vXYP_Itr lit, rit;
//	std::tie(lit, rit) = searchX_MinMax(lx, rx, src);
//
//	if (lit == src.end()) {	
//		return;
//	}
//	for (; lit != rit; ++lit) {
//		lit->second = 0.0;
//	}
//}

// src̎wԂY(Intensity)S0ɂB
// Ō̈̃Xg0ɂOIntensityi[B
inline void clearY(
	const double& lx, const double& rx, RFN::XYP::vXYP_& src, std::vector<double>& intensities) {
	ITR::vXYP_Itr lit, rit;
	std::tie(lit, rit) = searchX_MinMax(lx, rx, src);

	if (lit == src.end()) {	
		return;
	}
	for (; lit != rit; ++lit) {
		if (lit->second > 0) {
			intensities.push_back(lit->second);
			lit->second = 0.0;
		}
	}
}


//// $$$ gpӏ#2014.01.22
// ȉA܂Ŗgp
//---------------------------------------------------------
// svԂ֐QBIuWFNg߂
// [NNȎ̑΍QB
// OAԂ͊mۂ鉿lȂ΃f[^铙B
//---------------------------------------------------------

//// underPoint ȉ̘AԂa𕉂ŁAȊO̘a𐳂ŕԂB
//// EX) 0,0,4,5,2,0,0,1,0,9,9,9,.... => -2,3,-2,1,-1,3,...
inline const bool tranceZeroPoints (
	RFN::XYP::vXYP_& src,
	std::vector<int>& fgs
) {
	fgs.resize(src.size());
	std::vector<int>::iterator it = fgs.begin();
	bool gg, fg = false;
	ITR::vXYP_Itr itr = src.begin(), edItr = src.end();
	while(itr != edItr) {
		gg = (itr->second > 0.0);
		// O̒lƐقȂꍇ
		if (fg != gg) {
			fg = !fg;
			++it;
			*(it) = 0;
		}
		(*it) += (fg) ? 1 : -1;
		++itr;
	}
	// svȋԂ폜
	fgs.erase(std::remove(fgs.begin(),fgs.end(),0),fgs.end());
	return true;
}
//
// R[hŖgpB
//// src N_\Ȃ|Cg0ɂB
//// [in] lessnum : ̐lȉ̃|CgΏۂɂB
//// [in] zeroPts : Ԃ̑O "0"@O񂩁H
//// ex ) less : 1 / zeroPts 2 Ȃ
//// * * ! * * * * * * * * ! * * (! _)
//// 0 0 3 0 0 2 4 0 9 0 0 9 0 0
//inline const int toZeroLonlyOnlyPoint (
//	RFN::XYP::vXYP_& src, 
//	const unsigned int lessnum, 
//	const unsigned int zeroPts
//){
//	std::vector<int> fgs;
//	tranceZeroPoints(src, fgs);
//	return 0;
//}
//
// underPointȉ̋Ԃ,uLvȓ_݂
// keepZeroNum ȏ㑱ꍇ͍B
// s[N̍\̊֌WAŒAP_͕ۏ؂B
// EX) underPoint = 0, keepZeroNum=2
// ####00000000### Ȃ -> (####00)0000(00###) ()̋Ԃc
// ####0000### ̗lɂB
inline const bool deleteSereisOfZeroPoints(
	RFN::XYP::vXYP_&src,
	const unsigned int keepZeroNum
) {
	std::vector<int> fgs;
	unsigned int msCnt(0), deleteNum(0);
	unsigned int zeroNum = (keepZeroNum < 1) ?  1 : keepZeroNum;
	int limitVal = zeroNum * -2;
	// O̘AԂ擾
	tranceZeroPoints(src, fgs);
	std::vector<int>::iterator it = fgs.begin() , eit = fgs.end();

	while(it != eit) {
		// Ԃ
		if (*it < limitVal) {
			deleteNum = limitVal - *it;
			msCnt += zeroNum;
			for (unsigned int i = 0; i < deleteNum; i++) {
				src[msCnt].second = -1.0;
				msCnt++;
			}
			msCnt += zeroNum;
		} else {
			msCnt += std::abs(*it);
		}
		++it;
	}
	src.erase(std::remove_if(src.begin(),src.end(), underZeroY()), src.end());

	return true;
}

}// end of namespace
}

