/**********************************************************
/*! @addtogroup ANYPLUGINS(FUTURE)
    @file       AssistTool.h
    @brief      PluginCallTools Helper Functions Header
    @date       2012.10.16
	@author     M.Fukuda
	@version    1.0.0
	@note 
	
	Copyright(C) 2006-2013 Eisai Co., Ltd. 
	                       All rights reserved.
**********************************************************
	@par   
	Mass++PluginCalllNXEJvZB
	^ĂPluginCallȀ𓝍ׁB

	NXParamNameƋɍ쐬B
	SetUptF[Y setting͂ēe擾B
	s̉ۂ𔻒肷(RXgN^łׂ͂ł͂Ȃ)
	invokeŎsB
**********************************************************/
#pragma once
#include <string>

namespace mspp {
namespace sprt {

/*!--------------------------------------------------------
    @name   PeakDetector
    @breif 	PluginCallTool ́@Peak Detector@́@ȗxNXB
	@date   2012.10.23
	@par	pluginCallToolg^ȗNX
	        Setup  SeetingParameterValues̒g؂oB
			inovke sB
			eXsK؂ł falseԂB
-----------------------------------------------------------*/
/*! MASSPP UNIZON */
const std::string specFunc("SPEC_PEAK_PICKING");
const std::string chromFunc("CHROM_PEAK_PICKING");

class PeakDetector {
private:
	typedef kome::objects::SettingParameterValues tSetParam;

	const std::string paramName_; 	            /*! param name(From setting.xml data) */
	kome::plugin::PluginFunctionItem* m_func; 	/*! assigned peak detect function */
	tSetParam* m_setParams; 	                /*! peak detect function's param */
public:	
	/*! @breif constructor
	 *  @param[in] string : xml setting value name 
	 */
	explicit PeakDetector(const std::string& XMLparamname);

	/*! destructor */
	~PeakDetector();

	/*!
	 * @brief setup Class inner status.
	 * @param[in]  kome::objects::SettingParameterValues* : setting parameter object pointer
	 * @param[in]  bool : Call Peak Detector Type T/Chomatogram F/Spectrum
	 * @retval true Successed setup.
	 */
	const bool setUp(tSetParam* settings, bool isChrom);

	/*!
	 * @brief invoke set up peak detector
	 * @param[in]  kome::objects::XYData& : peaks XYData object
	 * @param[out] kome::ocjects::Peaks&  : detected result peaks objects  
	 * @retval true Successed peak picking
	 */
	const bool invokeMe(kome::core::XYData& xyData, kome::objects::Peaks& peaks);
};

/*!--------------------------------------------------------
    @name   PeakSmoother
    @breif 	Peak Smoothing@́@ȗxNXB
	@date   2012.10.24
	@par	pluginCallToolg^ȗNX
	        Setup  SeetingParameterValues̒g؂oB
			inovke sB
			eXsK؂ł falseԂB
-----------------------------------------------------------*/
/*! MASSPP UNIZON */
const std::string kXYDataSmooth("XYDATA_FILTER");

class PeakSmoother {
private:
	typedef kome::objects::SettingParameterValues tSetParam;

	const std::string paramName_; 	            /*! param name(From setting.xml data) */
	kome::plugin::PluginFunctionItem* m_func; 	/*! assigned peak detect function */
	tSetParam* m_setParams; 	                /*! peak detect function's param */
public:
	/*! @breif constructor
	 *  @param[in] string : xml setting value name 
	 */
	explicit PeakSmoother(const std::string& XMLparamname);
	
	/*! destructor */
	~PeakSmoother();

	/*!
	 * @brief setup Class inner status.
	 * @param[in]  kome::objects::SettingParameterValues* : setting parameter object pointer
	 * @retval true Successed setup.
	 */
	const bool setUp(tSetParam* settings);

	/*!
	 * @brief invoke smoothing to XYData
	 * @param[in.out]  kome::objects::XYData& : peaks XYData object
	 * @retval true Successed smoothing
	 * @note replace orginal data.
	 */
	const bool invokeMe(kome::core::XYData*& srcXY);

	/*!
	 * @brief invoke smoothing from src to dst
	 * @param[in]  kome::objects::XYData& : src peaks XYData object
	 * @param[out] kome::ocjects::XYData& : dst peaks XYData object
	 * @retval true Successed smoothing
	 */
	const bool invokeMe(kome::core::XYData& srcXY, kome::core::XYData& dstXY);
};

/*!--------------------------------------------------------
    @name   progress Keeper
    @breif 	Progress@́@ȗxNXB
	@date   2012.10.23
	@par	Renge쐬B
	        nextStep Ł@Position&StatusύXB
			fXgN^ProgressFillāYB
-----------------------------------------------------------*/
class ProgressKeeper {
private:
	kome::core::Progress& progress_; /*! ǗProgress */
	std::string status_;             /*! \bZ[W */
	unsigned int maxcount_;          /*! JEg̍ől */
	unsigned int totalcount_;        /*! JEg */
	unsigned int clockcount_;        /*! TCNPʂ̃JEg */
	unsigned int clockbasecount_;    /*! TCN̍őJEg */
	bool isEnd_;
public:
	ProgressKeeper (
		kome::core::Progress& progress, 
		unsigned int maxcount, 
		const std::string& statusMsg);
	// IuWFNgIFILLăN[Y
	~ProgressKeeper();
	// ɐi߂B
	void showNext();
	// IB
	void doFinish();
};

} // end of namespace
}
