/*********************************************************/
/*!
 @addtoGroup AB3D
 @file DBAccess.h
 @brief AB3D Peak Position DB Accesser Base
 
 @date 2013.07.01
 @author M.Fukuda
 @varsion 1.0.0

 -------------------------------------------------------
 Copyright(C) 2006-2014 
 Eisai Co., Ltd. All rights reserved.
 -------------------------------------------------------
 @note
 */
/*********************************************************/
#pragma once

namespace AB3D {

/*!--------------------------------------------------------
    @name   DbAccess
    @brief  Data Base Access Class
    @date   2013.07.01
    @par    IdentificationManager ̎ɈˑA
            DB𑀍삷ׂSQL,STMT̒`ǗB
-----------------------------------------------------------*/
	class DbAccess {

	public:
		// constructor
		DbAccess();
		// destructor
		~DbAccess();

	private:
		// Uncopyable
		DbAccess(const DbAccess&);
		DbAccess& operator=(const DbAccess&);

	public:
//		const bool setup();

		// Only Action
		const int getMaxID(const char* tablename);

		/*!
		 * @brief TempTable쐬
		 * @param[in]  %TABLE% 
		 * @param[in]  e[u`֐n
		 * @retval     ȂTԂ
		 * @note
		      e[u̐֐ addcolumnŊeX`̂nB
		 */
		const bool createTempTable(
			const char* tablename, 
			void (*ctFnc)(kome::db::Table& table, const char* tname));

		//------------------------------------------------
		// for create Statemet
		//------------------------------------------------

		/*!
		 * @brief SQLStmtɃZbg
		 * @param[in]  SQL
		 * @param[out] SQLZbgstatement.
		 * @retval     ȂTrueԂ
		 */
		const bool createStmt(
			const std::string& sql,
			kome::db::Statement*& refstmt);

		/*!
		 * @brief SelectSQLStmtɃZbg
		 * @param[in]  %TABLE% 
		 * @param[in]  selectvf
		 * @param[in]  where̗vf
		 * @param[out] SQLZbgstatement(ŃZbg)
		 * @retval     ȂOԂ
		 */
		const int createSelectStmt(
			const char* tname,
			const std::vector<const std::string>& sctVals, 
			const std::vector<const std::string>& whereVals,
			std::unique_ptr<kome::db::Statement>& refstmt);

		/*!
		 * @brief InsertSQLStmtɃZbg
		 * @param[in]  %TABLE% 
		 * @param[in]  insertvf
		 * @param[out] SQLZbgstatement.
		 * @retval     ȂOԂ
		 */
		const int createInsertStmt(
			const char* tname,
			const std::vector<const std::string>& vals,
			std::unique_ptr<kome::db::Statement>& refstmt);

		/*!
		 * @brief updateSQLStmtɃZbg
		 * @param[in]  %TABLE% 
		 * @param[in]  updatevf
		 * @param[in]  where̗vf
		 * @param[out] SQLZbgstatement.
		 * @retval     ȂOԂ
		 */
		const int createUpdateStmt(
			const char* tablename, 
			const std::vector<const std::string>& setVals, 
			const std::vector<const std::string>& whereVals,
			std::unique_ptr<kome::db::Statement>& refstmt);

	private:
		/*!
		 * @brief  DB̃|C^擾
		 * @retval DB̃|C^
		 */
		kome::db::Database* onGetDB();

		//-------------------------------------------------
		// on Prepare Statment
		//-------------------------------------------------

		/*!
		 * @brief SelectSQLStmtɃZbg
		 * @param[in]  %TABLE% 
		 * @param[in]  selectvf
		 * @param[in]  where̗vf
		 * @param[out] SQLZbgstatement.
		 * @retval     ȂOԂ
		 */
		const int setStatement_Select(
			const char* tablename, 
			const std::vector<const std::string>& setVals, 
			const std::vector<const std::string>& whereVals,
			kome::db::Statement*& refstmt);

		/*!
		 * @brief InsertSQLStmtɃZbg
		 * @param[in]  %TABLE% 
		 * @param[in]  insertvf
		 * @param[out] SQLZbgstatement.
		 * @retval     ȂOԂ
		 */
		const int setStatement_Insert(
			const char* tablename, 
			const std::vector<const std::string>& intoVals,
			kome::db::Statement*& refstmt);

		/*!
		 * @brief updateSQLStmtɃZbg
		 * @param[in]  %TABLE% 
		 * @param[in]  updatevf
		 * @param[in]  where̗vf
		 * @param[out] SQLZbgstatement.
		 * @retval     ȂOԂ
		 */
		const int setStatement_Update(
			const char* tablename, 
			const std::vector<const std::string>& setVals, 
			const std::vector<const std::string>& whereVals,
			kome::db::Statement*& refstmt);

		//-------------------------------------------------
		// z񂩂SQLŗĽJԂ
		//-------------------------------------------------
		/*!
		 * @brief [select (v1,v2,..) from %TABLE%]
		 * @param[in]  %TABLE% 
		 * @param[in]  selectvf
		 * @retval     SQL
		 * @note       where͕ʓr
		 */
		const std::string makeSQL_Select(
			const char* talbename,
			const std::vector<const std::string>& vals);

		/*!
		 * @brief [insert into %TABLE% (v1,v2,..) values(?,?,..)]SQL
		 * @param[in]  %TABLE% 
		 * @param[in]  insertvf
		 * @retval     SQL
		 * @note       where͕ʓr
		 */
		const std::string makeSQL_Insert(
			const char* tablename, 
			const std::vector<const std::string>& vals);

		/*!
		 * @brief SQL[update %TABLE% set val1=?, ...]
		 * @param[in]  %TABLE% 
		 * @param[in]  updatevf
		 * @retval     SQL
		 * @note       where͕ʓr
		 */
		const std::string makeSQL_Update(
			const char* tablename, 
			const std::vector<const std::string>& vals);

		/*!
		 * @brief SQL[where st1=? AND st2=?,...]
		 * @param[in]  %TABLE% 
		 * @param[in]  where̗vf
		 * @retval     SQL
		 */
		const std::string makeSQL_Where(
			const std::vector<const std::string>& vals);
	};

/*!--------------------------------------------------------
    @name   setTableInfo
    @brief  e[u̍쐬⏕
    @date   2013.07.01
    @par    DBe[u쐬̌ŗL[Z߂
-----------------------------------------------------------*/
	class setTableInfo {
	public:

		/*!
		 * @brief constructor
		 * @param[in] e[u
		 * @param[in] e[uIuWFNg
		 */
		setTableInfo(
			const char* tname,
			kome::db::Table& table);

		// destrcutor
		~setTableInfo(){}
	private:
		/* inner elements */
		kome::db::Table& table_;

	public:
		/*!
		 * @brief e[uvf̍쐬
		 * @param[in] J
		 * @param[in] f[^^Cv(integet,String)
		 * @param[in] ͂ȂȂTrue
		 * @param[in] Z(ID̃^Cv)ȂTrue.
		 */
		void addColumn(
			const std::string& colname,
			const kome::db::TableColumn::DataType& coltype,
			bool notNull = false,
			bool autoincrement = false);

	};

}
