///*********************************************************/
///*!
// @addtoGroup AB3D
// @file AB3DPeakPosition.cpp
// @brief AB3D Peak Position Algorizhm
// 
// @date 2013.07.01
// @author M.Fukuda
// @version 1.0.0
//
// -------------------------------------------------------
// Copyright(C) 2006-2014 
// Eisai Co., Ltd. All rights reserved.
// -------------------------------------------------------
// @note
//    AB3DIuWFNgƓĂ܂B
//    Plugin Call Mass++IuWFNgϊ̃RXg傫̂ŁA
//    ʏPluginCallƂ͈قȂt[ŏĂ܂B
// */
///*********************************************************/
//
////
//// ؎ɂāB
//// PeakPosition臒ľvZ͗vłB
//// i荞݌Ãs[Nꍇ̏ɂĂvłB
////
//
//#include "stdafx.h"
//#include "AB3DPeakPosition.h"
//
//// include AB3D Parts
//#include "NewAB3DLabeling.h"
//
//// include DB Controler
//#include "DBTools\DbController.h"
//#include "DBTools\tempContainer.h"
//
//// include progress controler
//#include "progress\progressMatrix.h"
//
//#define AB3D_SHORT_NAME "ab3d2"
//
//#include <fstream>
//
//// constructor
//AB3DPeakPositions::AB3DPeakPositions(
//	const double mzppm,
//	const double rttol,
//	std::map<std::string, std::string>& setmap,
//	kome::objects::SettingParameterValues* settings
//	) : mzppm_(mzppm)
//	, rttol_(rttol)
//	, setmap_(setmap)
//	, settings_(settings)
//{}
//
////********************************
//// s
////********************************
//// Tv
//// 01.AB3D̒ŁAƂȂ XICXYData f[^APeak̏擾/ۑ
//// 02.AB3Ď㔼̏ŁA[Peakł]f[^XV(Flag𗧂Ă)
//// 03.STvŁAAB3DIA[Peakł]f[^SĎ擾
//// 04.TvPeakŁA臒l M/Z, RT, Charge̒lZ߁A
////    m肵lAe[uMatrix@Row(Peakl)ƂďށB
//// 05.teValue̒lTempTableRs[B
//// 06.Kvȕ̌vZSčsƁAMatrixoオB
//// 07.ITemp TableĵŁAsvȒlDBɂ͎cȂB
////--------------------------------
//const bool AB3DPeakPositions::execute (
//	kome::core::Progress& progress
//) {
//	// DB Object
//	std::unique_ptr<AB3D::DbController> dbctrl(new AB3D::DbController);
//
//	// check DB Status
//	if (dbctrl->checkDBStatus() && (dbctrl->setupTempTables() != true)){
//		// DBgȂ or TempTableȂ̂ŏłȂ
//		LOG_ERROR_CODE(FMT("Failed to access database."),ERR_DB);
//		return false;
//	}
//
//	// Execute AB3D
//	if (onExecAB3D(dbctrl.get(), progress)) {
//		// Exec Create Matrix
//		if(onCreateMatrix(dbctrl.get(), progress)) {
//			// 
//			LOG_INFO(FMT("Complete create matrix."));
//			return true;
//		} else {
//			// CreateMatrixɎs
//			LOG_ERROR(FMT("Failed to create matrix table."));
//		}
//	} else {
//		//AB3DɎs
//		LOG_ERROR(FMT("Failed to execute AB3D."));
//	}
//	return false;
//}
//
//// AB3Ds
//const bool AB3DPeakPositions::onExecAB3D(
//	AB3D::DbController* dbctrl,
//	kome::core::Progress& progress
//){
//	//AB3D object
//	NewAB3DLabeling ab3d(setmap_);
//
//	// Progress X^[g
//	MatrixProg prog(&progress, dbctrl->getSampleNumbers());
//
//	// TvJԂB
//	while(dbctrl->doNextSample() && !progress.isStopped() ) { // @date 2013.11.22 <Mod> M.Izumi
//		kome::objects::DataSet dataSet;
//		//vZp̃IuWFNgDB擾
//		if(dbctrl->getNowDataGroup(dataSet)) {
//			kome::core::Progress* subProgress = prog.getSubProgress();
//			ab3d.bindProgress(subProgress);
//			// AB3DsB
//			ab3d.doAB3D(dataSet, dbctrl);
//		} else {
//			// dataSet擾łȂꍇB
//			LOG_ERROR(FMT("Faild to the dataSet"));
//			return false;
//		}
//	}
//	prog.closeMe();
//	return true;
//}
//
//// Matrix쐬
//// Progress̊Ǘړr҂
//const bool AB3DPeakPositions::onCreateMatrix(
//	AB3D::DbController* dbctrl,
//	kome::core::Progress& progress
//){
//	return this->onCreateMatrix(dbctrl);
//}
//
//// Matrix쐬
//const bool AB3DPeakPositions::onCreateMatrix(
//	AB3D::DbController* dbctrl
//){
//	std::vector<AB3D::TmpPeakVal*> tmpPeaks;
//	std::vector<AB3D::TmpPeakVal*> errPeaks;
//	
//	// Temp Table Charge > -2 PeakAValue̍~Ŏ擾B
//	// TmpPeakVal͓[New]Ė߂B
//	if(dbctrl->getMatchDataFromTemp(tmpPeaks)) {
//
//		std::vector<stRows> rowArr;
//		// Matrix Peaks Roẅׂ̃IuWFNgB
//		std::for_each(tmpPeaks.begin(), tmpPeaks.end(), [&](AB3D::TmpPeakVal* p){
//			if(!setupMatrixPeakRow(p, rowArr)) {
//				errPeaks.push_back(p);
//			}
//		});
//		// for Debug 
//		//debugPrint(tmpPeaks,errPeaks,rowArr);
//
//		// Matrix DBɃIuWFNg̗vf
//		this->onWriteToMatrix(dbctrl, rowArr);
//
//		// NewꂽIuWFNgDeleteB
//		for each(auto tpv in tmpPeaks){delete tpv;}
//
//		//std::for_each(tmpPeaks.begin(), tmpPeaks.end(), [](const AB3D::TmpPeakVal* tpv){
//		//	delete tpv;
//		//});
//		
//	} else {
//		// 擾Ɏs or ʂȂ
//		LOG_ERROR(FMT("No Result"));
//		return false;
//	}
//	return true;
//}
//
//// Matrix Peaks Roẅׂ̃IuWFNgB
//// Labeling & Margeɓ鏈sB
//const bool AB3DPeakPositions::setupMatrixPeakRow(
//	AB3D::TmpPeakVal* pt,
//	std::vector<stRows>& rowArr
//){
//	bool newFg = true;
//	bool ret = true;
//	std::vector<stRows>::iterator it = rowArr.begin();
//	std::vector<stRows>::iterator eit = rowArr.end();
//
//	for(; it != eit && newFg; ++it) {
//		//o^ςROW(it)͈͓̔𔻒
//		if(isInRow(pt, *it)) {
//			// ͈͓
//			newFg = false;
//			if(!isSameIdInRow(pt->sampleId, *it)) {
//				// SampleIDdBq̗vfƂēo^B
//				it->vals.push_back(pt);
//			} else {
//				//Sample臒l̃s[Nꍇ㏑uo^Ȃv
//				//ʓrPeak Row𕪂KvLꍇ͋LqB
//				ret = false;
//			}
//		}
//	}
//	//o^ς݂ROWƈvBVKvfƂēo^B
//	if(newFg) {
//		rowArr.push_back(createRows(pt));
//	}
//	return ret;
//}
//
//// Ώۂ row臒lƓۂԂ
//const bool AB3DPeakPositions::isInRow(
//	AB3D::TmpPeakVal* p,
//	const stRows& row
//){
//	// Chargesv
//	if (p->charge != row.charge) return false;
//	// m/z臒lO
//	if (p->mz < row.mztol.lo || row.mztol.hi < p->mz) return false;
//	// rt臒lO
//	if (p->rt < row.rttol.lo || row.rttol.hi < p->rt) return false;
//	// 臒lŊChargeB̂ɈvB
//	return true;
//}
//
////@̒ɁASamplẽs[N邩ۂTB
//const bool AB3DPeakPositions::isSameIdInRow(
//	const int tgtId, 
//	const stRows& tgtRow
//){
//	for each(auto& t in tgtRow.vals) {
//		if(t->sampleId == tgtId) return true;
//	}
//	return false;
//}
//
//// row𐶐
//stRows AB3DPeakPositions::createRows(
//	AB3D::TmpPeakVal* p
//){
//	stRows rst(p->mz, p->rt, p->charge);
//	double mztol = p->mz * 0.000001 * mzppm_;
//	// 臒lp͈̔͂vZĕێB
//	rst.mztol = tolerance(p->mz, mztol);
//	rst.rttol = tolerance(p->rt, rttol_);
//	rst.vals.push_back(p);
//	return rst;
//}
//
//
//// Matrix̎̂쐬
//const bool AB3DPeakPositions::onWriteToMatrix(
//	AB3D::DbController* dbctrl,
//	std::vector<stRows>& rowArr
//) {
//	// Matrix̎̕쐬ׂ̈STMT쐬B
//	if (!rowArr.empty() && dbctrl->setupMsppSTMT()) {
//		std::for_each(rowArr.begin(), rowArr.end(), [&](stRows& r){
//			dbctrl->writeRowLine(r.mz, r.rt, r.charge, r.vals);
//		});
//		dbctrl->finishMakeMatrix(true);
//		return true;
//	}
//	return false;
//}
//
////-----------------------------------------------------
////For Debug Matrix only
////-----------------------------------------------------
//void AB3DPeakPositions::debugPrint(
//	std::vector<AB3D::TmpPeakVal*>& tmpPeaks,
//	std::vector<AB3D::TmpPeakVal*>& errPeaks,
//	std::vector<stRows>& rowArr
//){
//	std::string AllResults = "R:\\tmpPeaks.txt";
//	std::string AllRow = "R:\\rowvals.txt";
//	std::string ErrResults = "R:\\errPeaks.txt";
//
//	//--AB3D̑Sʂ܂B
//	this->debugOutputTmpPeaksValues(AllResults, tmpPeaks);
//	//--Matrix\IuWFNg̓e܂
//	this->debugOutputRowValues(AllRow, rowArr);
//	//--Labeling&MergẽASYɂuo^Ȃvf[^܂
//	this->debugOutputTmpPeaksValues(ErrResults, errPeaks);
//}
//
//// Debugp TmpPeaksValues̒gSďo
//void AB3DPeakPositions::debugOutputTmpPeaksValues(
//	const std::string& outputfilePath,
//	const std::vector<AB3D::TmpPeakVal*>& tmpPeaks
//){
//	std::ofstream ofs(outputfilePath);
//	ofs << getTmpPeakAllElements(nullptr) << std::endl;
//
//	std::for_each(tmpPeaks.begin(),tmpPeaks.end(),
//		[&](AB3D::TmpPeakVal* p){ofs << getTmpPeakAllElements(p) << std::endl;});
//	ofs.close();
//}
//
//// Debug Row Values̒gmFp
//void AB3DPeakPositions::debugOutputRowValues(
//	const std::string& outputfilePath,
//	const std::vector<stRows>& rowArr
//){
//	std::ofstream ofs2(outputfilePath);
//	ofs2 << "mxId,m/z,rt,z," << getTmpPeakAllElements(nullptr) << std::endl;
//	std::string hs(""),ss("");
//	int cnt = 1;
//
//	for each(auto& r in rowArr) {
//		hs = FMT("%d,%f,%f,%d,",cnt, r.mz, r.rt, r.charge);
//		for each(auto& vt in r.vals) {
//			ss = getTmpPeakAllElements(vt);
//			ofs2 << hs << ss << std::endl;
//		}
//		cnt++;
//	}
//	ofs2.close();
//}
//
//// Debugp
//const std::string AB3DPeakPositions::getTmpPeakAllElements(
//	AB3D::TmpPeakVal* p
//){
//	std::string ts;
//	if(p != nullptr) {
//		ts = FMT("%f,%f,%d,%d",p->mz, p->rt, p->charge, p->sampleId);
//		ts += FMT(",%f", p->mxval.value);
//		ts += FMT(",%f,%f", p->mxval.core.x, p->mxval.core.y);
//		ts += FMT(",%f,%f", p->mxval.left.x, p->mxval.left.y);
//		ts += FMT(",%f,%f", p->mxval.right.x, p->mxval.right.y);
//	} else {
//		ts = "m/z,rt,z,sampleId,value,Core.x,Core.y,Left.x,Left.y,Right.x,Right.y";
//	}
//	return ts;
//}
//
////AB3D ̂̂TempTableɓfoāAs
//const bool AB3DPeakPositions::executeDebug (
//) {
//	// DB Object
//	std::unique_ptr<AB3D::DbController> dbctrl(new AB3D::DbController);
//	dbctrl->setupTempSTMT();
//	dbctrl->checkDBStatus();
//	bool ret = true;
//	//FeedBack Results from temp table
//	ret = this->onCreateMatrix(dbctrl.get());
//	
//	return true;
//}
