/**
 * @file SampleTreeBuilderFunctions.cpp
 * @brief implementation of plug-in functions
 *
 * @author okada_h
 * @date 2012.09.28
 * 
 * Copyright(C) 2006-2014 Shimadzu Corporation All rights reserved.
 */


#include "stdafx.h"
#include "SampleTreeBuilderFunctions.h"
#include "SampleTreeBuilderManager.h"

#include <memory>	// for auto_ptr

using kome::plugin::FileFactory;	// for FileFactory
using kome::objects::SampleSet;		// for SampleSet
using kome::objects::Sample;		// for Sample
using kome::objects::DataGroupNode;	// for DataGroupNode
using kome::objects::Spectrum;		// for Spectrum

using kome::SampleTreeBuilder::SampleTreeBuilderSampleSet;
using kome::SampleTreeBuilder::SampleTreeBuilderSample;

#define MEMORY_LEAKER			/*NO_ACTION*/
#define MEMORY_LEAKER_TXT(X)	/*NO_ACTION*/


SampleTreeBuilderSampleSet::SampleTreeBuilderSampleSet(){

	m_p_csv_parser = new CsvParser;

	m_ptr_sample_new = NULL;

	SampleTreeBuilderManager &mgr = SampleTreeBuilderManager::getInstance();
	mgr.registPtr( this );
};


SampleTreeBuilderSampleSet::~SampleTreeBuilderSampleSet()
{

	delete m_p_csv_parser;	// @date 2012/10/03 <Add> OKADA
	m_p_csv_parser=NULL;

	SampleTreeBuilderManager &mgr = SampleTreeBuilderManager::getInstance();
	mgr.unregistPtr( this );

};

// on open file
bool SampleTreeBuilderSampleSet::onOpenFile( const char* path, kome::core::Progress* progress )  // add param @date 2014.07.08 <Mod> M.Izumi
{
	path = NULL;	// @date 2013/06/10 <Add> OKADA	// warning C4100: 'path' : ͊֐̖{̕ 1 xQƂ܂B
//	Sample̔hNXASampleTreeBuilderSample 쐬
	SampleTreeBuilderSample  *ptr_sample_new = new SampleTreeBuilderSample( this );
	m_ptr_sample_new = ptr_sample_new;

	this->addSample( ptr_sample_new );	// addSample

	return ptr_sample_new->openSample();	// SampleTreeBuilderSampleonOpenSample( rootGroup )Ă΂BrootGroupɂ͏ς݃CX^X
}

// on close file
bool SampleTreeBuilderSampleSet::onCloseFile() 
{
	return true;
}

// on open sample
bool SampleTreeBuilderSampleSet::onOpenSample( kome::objects::Sample* sample, kome::core::Progress* progress )  // add param @date 2014.07.08 <Mod> M.Izumi
{
	sample = NULL;	// @date 2013/06/10 <Add> OKADA	// warning C4100: 'sample' : ͊֐̖{̕ 1 xQƂ܂B
	return true;
}

// on close sample
bool SampleTreeBuilderSampleSet::onCloseSample( kome::objects::Sample* sample ) 
{
	sample = NULL;	// @date 2013/06/10 <Add> OKADA	// warning C4100: 'sample' : ͊֐̖{̕ 1 xQƂ܂B
	return true;
}

/* 啶ɒĔr */
int capitalized_strcmp(const char *s1, const char *s2)
{
    while (toupper(*s1) == toupper(*s2)) {  /* ԃ[v */
        if (*s1 == '\0'){                   /* ܂œ */
            return (0);                     /* OԂ */
		}
        s1++;                               /* ̓rȂ̂ */
        s2++;                               /* CNg */
    }    /* Ȃ̂ŕ̒l̍Ԃ */
    return (toupper(*s1) - toupper(*s2));
};


bool SampleTreeBuilderSample::onOpenSample( DataGroupNode* rootGroup, kome::core::Progress* progress ) 
{
	bool bRet = false;

	if( rootGroup == NULL ){
		return false;	// G[
	}
	
	CsvParser* ptrCsvParser;
	ptrCsvParser = m_sampleSet->getPtrCsvParser();
	size_t sizeOfCsvDatas = ptrCsvParser->getNumberOfCsvData();	// csvt@C̍s
	for( unsigned int i=0; i<sizeOfCsvDatas; i++ ){

		SampleSet* pSsSource = NULL;

		std::string strDataType = ptrCsvParser->getCsvData( i ).getDataType();
		if( capitalized_strcmp( strDataType.c_str(), "file" ) == 0 ){
			// fileǂݍݏ
			FileFactory& factory = FileFactory::getInstance();
			std::string strFilename = ptrCsvParser->getCsvData( i ).getKey();
			pSsSource = factory.openFile( strFilename.c_str(), NULL );	// add param
		}else{
			// DIT-FP̓ǂݍݏ
		}
		if (pSsSource == NULL) {
			std::string strFilename = ptrCsvParser->getCsvData( i ).getKey();
			printf( "Error: Can't open file. '%s'\n", strFilename.c_str() );
			return false;	// G[
		}
		ptrCsvParser->getCsvData( i ).setSs( pSsSource );	// G

		// Sample SetɊ܂܂ĂTv̌𓾂
		Sample* sampleSource = NULL;

		unsigned int nSample = 0;	// ŏ̂P̂ݓǂݎ
		sampleSource = pSsSource->getSample(nSample);
		if( sampleSource == NULL ){ 
			continue;	// nSampleԖڂ̃Tv擾łȂ
		}
		
		bool bOpenedSource = sampleSource->isOpened();
		if( bOpenedSource == false ){
			sampleSource->openSample();	// ǂݏot@C̃TvI[vĂȂ΃I[v
		}
		
		// 擾XyNg̖O𓾂iopenFile()֐ĂԑOɐݒ肵j
		std::string strSpecName = ptrCsvParser->getCsvData( i ).getSpectrum();
		if( strSpecName == "" ){ 
			printf( "Error: Spectrum not found. \n" );
			continue; 
		}

		// ǂݏot@C̃Tvroot node𓾂
		DataGroupNode* nodeSource = sampleSource->getRootDataGroupNode();
		if (nodeSource == NULL){
			continue;	// ǂݏot@Croot nodeiDataGroupNodej擾łȂ
			// ʏ킠蓾Ȃ
		}

		// XyNgŌăXyNg𓾂
		Spectrum* spec_Source = NULL;
		if( strSpecName != "*" ){
			spec_Source = getSpecByName( nodeSource, strSpecName.c_str() );
		}else{
			int n = 0;
			spec_Source =  nodeSource->getSpectrum(n);   // SpecName  * ̏ꍇɂ́A擪̃XyNgΏۂƂB
		}
		if( spec_Source == NULL ){ 
			// ̖ÕXyNǵAǂݍ݌t@Cɂ܂ł
			printf( "Error: Spectrum not found. '%s'\n",  strSpecName.c_str() );
			return false;	// G[
		}

		ptrCsvParser->getCsvData( i ).setSpec( spec_Source );	// J

		// L
		// ew肳Ă邩`FbN
		std::string strParent = ptrCsvParser->getCsvData( i ).getParent();

		if( strParent == "*" ){
			// e͎w肳ĂȂ
			ptrCsvParser->getCsvData( i ).setPspec( NULL );	// N

			int nStageNum = atoi( ptrCsvParser->getCsvData( i ).getStageStr().c_str() );
			ptrCsvParser->getCsvData( i ).setStage( nStageNum );

		}else{
			// e͎w肳Ă
			int nParent = atoi( strParent.c_str() );

			if( (int)sizeOfCsvDatas < nParent ){
				// Ŝ̍s傫lw肳Ă̂NG
				printf( "Error: Parent spectrum is not found. row no=%d\n", nParent );
				return false;	// G[
			}else{
				;
			}
			if( nParent <= 0 ){
				// eԍ́A1`
				return false;	// G[
			}
			// e̎ẃA݂̍sԍႭȂ΂ȂȂ
			if( nParent < ptrCsvParser->getCsvData( i ).getRow() ){
				// 
			}else{
				// eԍ
				printf( "Error: Parent spectrum is not right. Number=%d\n", nParent );
				return false;	// G[
			}
			// e͎w肳Ă
			bool flgIcchi = false;
			int nParentIndex = -1;
			for( unsigned int j=0; j<i; j++ ){
				if( nParent == ptrCsvParser->getCsvData( j ).getRow() ){
					// v
					Spectrum* pSpec = ptrCsvParser->getCsvData( j ).getSpec();
					ptrCsvParser->getCsvData( i ).setPspec( pSpec );	// N
					flgIcchi = true;
					nParentIndex = j;
				}
			}
			if( flgIcchi == false ){
				// w肳ꂽe̍sԍȂ
				return false;	// G[	
			}

			int nStageNum = atoi( ptrCsvParser->getCsvData( i ).getStageStr().c_str() );
			ptrCsvParser->getCsvData( i ).setStage( nStageNum );
		}

		// XyNgbp[NXɕϊ
		kome::operation::TransformedSpectrum* trans_spec = new kome::operation::TransformedSpectrum( *spec_Source );
		if( trans_spec == NULL ){ continue;	}

		//  trans_spec ̓eH 
		// eXyNgݒ
		{
			int nParent = atoi( strParent.c_str() );	// strParentu*v̏ꍇAnParent0ɂȂ邩AǂƂvȂ
			bool flgIcchi = false;
			for( unsigned int j=0; j<i; j++ ){
				if( nParent == ptrCsvParser->getCsvData( j ).getRow() ){
					// v
					flgIcchi = true;
					trans_spec->setParentSpectrum( ptrCsvParser->getCsvData( j ).getTransSpec() );
				}
			}
			if( flgIcchi == false ){	// e΁AÔNULL
				trans_spec->setParentSpectrum( NULL );
			}
		}

		// MS Stageԍݒ

		// eXyNgw肳ĂAi1j
		// AeXyNgMS Stageԍꍇi2j
		bool flgIn = false;
		if( std::string::npos == strParent.find( "*", 0 ) )			// 1
		{	// 1
			int nParentMSStageNo = -1;

			// eMS Stageԍ擾
			int nParent = atoi( strParent.c_str() );
			for( unsigned int j=0; j<i; j++ ){
				if( nParent == ptrCsvParser->getCsvData( j ).getRow() ){
					// v
					nParentMSStageNo = ptrCsvParser->getCsvData( j ).getStage();
				}
			}

			if( 0 < nParentMSStageNo ){	// 2
				flgIn = true;
				std::string strMSStageNum = ptrCsvParser->getCsvData( i ).getStageStr();
				if( strMSStageNum != "*" ){
					// e+1w肳ĂOK
					if(ptrCsvParser->getCsvData( i ).getStage() == nParentMSStageNo+1){
						// e+1w肳Ă̂OK
					}else{
						// xbZ[W\
						printf( "Warning: MS Stage is %d in csv file. Right value is %d. \n", ptrCsvParser->getCsvData( i ).getStage(), nParentMSStageNo+1 );
					}
					ptrCsvParser->getCsvData( i ).setStage( nParentMSStageNo+1 );	// e+1̒lɂȂ
				}else{
					ptrCsvParser->getCsvData( i ).setStage( nParentMSStageNo+1 );	// e+1̒lɂȂ
				}
				
			}
		}
		if( flgIn == false ){
			// LA1/2̂ǂɂĂ͂܂Ȃꍇ
			std::string strMSStageNum = ptrCsvParser->getCsvData( i ).getStageStr();
			if( std::string::npos == strMSStageNum.find( "*", 0 ) ){
				// MSStage l`FbN
				int nMSStage = atoi(strMSStageNum.c_str());
				if(( nMSStage < 1 )||( 10 < nMSStage )){
					printf( "Error: MS Stage is %d\n", nMSStage );
					return false;	// G[
				}

				// ̂܂
				ptrCsvParser->getCsvData( i ).setStage( atoi(strMSStageNum.c_str()) );
			}else{
				// MS Stage"*" ݒ肳Ă

				// MSStage擾
				int nOriginalMSStageNo = ptrCsvParser->getCsvData( i ).getSpec()->getMsStage();
				ptrCsvParser->getCsvData( i ).setStage( nOriginalMSStageNo );
				if( 0 < nOriginalMSStageNo ){	// MSStageݒ肳Ă
					ptrCsvParser->getCsvData( i ).setStage( nOriginalMSStageNo );
				}else{
					ptrCsvParser->getCsvData( i ).setStage( nOriginalMSStageNo );
					// ݒ肳ĂȂBxB
					printf( "Warning: Original MS Stage is not seted.\n" );
				}
			}
		}
		// ACRMS1, MS2, MS3, MS4, MS5, MS6, MS7, MSn܂B8ȏ MSn ̃ACRɂĉB
		int nStage = ptrCsvParser->getCsvData( i ).getStage();
		trans_spec->setMsStage( nStage );
		if(( 1 <= nStage )&&( nStage <= 7 )){	// MSACRw
			char szIcon[16];
			sprintf( szIcon, "MS%d", nStage );
			trans_spec->setIcon( szIcon );
		}else if( 8 <= nStage ){
			trans_spec->setIcon( "MSn" );
		};

		// vJ[TCIʂ̐ݒ //////////

		// ŎwBύXȂꍇ́u*vBMS Stageԍ1̏ꍇ́uvi̐jƂ
		std::string strPcMass = ptrCsvParser->getCsvData( i ).getPcMassStr();
		if( std::string::npos == strPcMass.find( "*", 0 ) ){
			// "*"
			// MS Stageԍ1̏ꍇ́uv
			if( ptrCsvParser->getCsvData( i ).getStage() == 1 ){
				trans_spec->setPrecursor( -1.0 );
				ptrCsvParser->getCsvData( i ).setPcMassNum( -1.0 );
			}else{
				double precursor = atof( strPcMass.c_str() );
				trans_spec->setPrecursor( precursor );
				ptrCsvParser->getCsvData( i ).setPcMassNum( precursor );
			}
		}else{
			// ύXȂ
			double precursor = trans_spec->getPrecursor( ptrCsvParser->getCsvData( i ).getStage() );
			ptrCsvParser->getCsvData( i ).setPcMassNum( precursor );
		}

		// eV^C̐ݒ //////////

		// ŎwBύXȂꍇ́u*vBu*vw莞Ɍf[^ɃeV^Cݒ肳ĂȂꍇ́Ax
		std::string strRT =  ptrCsvParser->getCsvData( i ).getRetentionTimeStr();

		if( std::string::npos == strRT.find( "*", 0 ) ){
			// "*"
			double dRT = atof( strRT.c_str() );
			ptrCsvParser->getCsvData( i ).setRetentionTime( dRT );
			trans_spec->setRt( dRT );
			trans_spec->setHasChromatogram( true );	// @date 2013/03/27 <Add> OKADA
		}else{
			// "*"
			// ύXȂ
			// u*vw莞Ɍf[^ɃeV^Cݒ肳ĂȂꍇ́Ax
			double dRT = trans_spec->getRt();
			if( dRT < 0 ){
				// eV^Cݒ肳ĂȂ
				// x
				printf( "Warning: Retention time is nothing." );
			}
			ptrCsvParser->getCsvData( i ).setRetentionTime( dRT );
		}

		// SPEC 88275
		// scan numberAe[uicsv)̍sԍ-1ɐݒ肷
		trans_spec->setScanNumber( i );	// loop counteriϐ ij0n܂̂ŁAiZbg // @date 2012/10/22 <Add> OKADA

		ptrCsvParser->getCsvData( i ).setTransSpec( trans_spec );	// trans_specۑ

		// XyNgǉ
		rootGroup->addSpectrum( trans_spec );	// root node ̉ɒǉiKw݂͐Ȃj
		bRet = true;

	}

	return bRet;
}


bool SampleTreeBuilderSample::onCloseSample() {
	return true;
};

// DataGroupNode疼OŃXyNg
Spectrum* getSpecByName( DataGroupNode* node, const char *szRequestedName ){
	const unsigned int numSpec = node->getNumberOfSpectra();
	for (unsigned int n = 0; n < numSpec; n++){
		Spectrum* spec = node->getSpectrum(n);
		const char *szName = spec->getName();


		// 啶EʂȂri"Scan 0""scan 0"𓯂悤Ɉj
		size_t sizeName          = strlen(szName);
		size_t sizeRequestedName = strlen(szRequestedName);

		if( sizeName != sizeRequestedName ){
			continue;	// 񒷂قȂ̂ŕsvBvȂ̂Ŏ̕T
		}

		bool flgIcchi = true;
		for( size_t sizeCount=0; sizeCount<sizeName; sizeCount++ ){
			if( toupper( szName[sizeCount] ) == toupper( szRequestedName[sizeCount] ) ){
				// v
			}else{
				// sv
				flgIcchi = false;
				break;
			}
		}
		if( flgIcchi == false ){
			continue;	// vȂ̂Ŏ̕T
		}else{
			// v
			return spec;	
		}
	}

	const unsigned int numChild = node->getNumberOfChildren();
	for (unsigned int n = 0; n < numChild; n++){
		DataGroupNode* child = node->getChild(n);
		if (child != NULL){
			return getSpecByName(child, szRequestedName);
		}
		else{
			assert(false);
		}
	}

	return NULL;
}

// --------------------
// CsvParser
// --------------------
// constructor
CsvParser::CsvParser(){
};

// destructor
CsvParser::~CsvParser(){
};


// R}hCsƂ̃Gg֐
kome::objects::Variant execSampleTreeBuilderCommandline( kome::objects::Parameters* params) 
{
	// return value
	kome::objects::Variant ret;
	ret.type = kome::objects::Variant::BOOL;
	ret.prim.boolVal = false;

	ret = execSampleTreeBuilderBatch( params );

	return ret;
}

// j[sƂ̃Gg֐
kome::objects::Variant execSampleTreeBuilderBatch( kome::objects::Parameters* params ) 
{
	// return value
	kome::objects::Variant ret;
	ret.type = kome::objects::Variant::BOOL;
	ret.prim.boolVal = false;

	SampleTreeBuilderSampleSet *pSampleSetNew = new SampleTreeBuilderSampleSet;

	bool flgNonError = true;
	bool flgFileOpenOk = false;
	if( pSampleSetNew ){

		// csvt@Cǂݍ

		// CSVt@C擾
		// get settings
		kome::objects::SettingParameterValues* settings
			= kome::plugin::PluginCallTool::getSettingValues( params );
		if( settings == NULL ) {
			LOG_ERROR( FMT( "Failed to get the parameters file path." ) );
			return ret;
		}

		// csv file name
		const char* pszCsvFileName = NULL;
		pszCsvFileName = settings->getParameterValue( "csv_filename" );

		FILE * fp;
		char szRow[1024] = { '\0' };	// NULLŖ߂

		fp = fopen( pszCsvFileName , "r" );
		if( fp == NULL ) {
			printf( "Error: Can not open this file '%s'\n", pszCsvFileName );
			return ret;	// t@CI[vG[
		}

		while( fgets( szRow , sizeof( szRow ) , fp ) != NULL ) {
			szRow[sizeof( szRow )-1] = '\0';	// svÔ

			size_t length = strlen(szRow);
			if( sizeof(szRow)-length <= 1 ){
				// buffert܂œǂݍł
				printf( "row=%s", szRow );/* szRow̖\n\0 */
				printf( "Error: Buffer over flow. In csv file, maximu length is %d bytes by row. \n", sizeof( szRow )-1 );
				fclose(fp);
				return ret;
			}
			if( szRow[0] == CSV_COMMENT_LETTER ){
				// RgsłI
				printf( "Comment=%s" , szRow );
			}else{

				printf( "row=%s", szRow );/* szRow̖\n\0 */

				int nRet = pSampleSetNew->getPtrCsvParser()->addRow( szRow );	// CSVp[Tɗ^
				if( nRet != 0 ){
					flgNonError = false;	// G[
					break;
				}
				// sԍ`FbN
				{
					// sԍُ킩ۂ`FbN
					int nLines = pSampleSetNew->getPtrCsvParser()->getNumberOfCsvData();
					if( 1 <= nLines ){
						int nRow = pSampleSetNew->getPtrCsvParser()->getCsvData( nLines-1 ).getRow();
						if( nRow == nLines ){
							// sƍŐV̍sԍvBOK
						}else{
							;	// sԍُ
							printf( "Error: Row number error.\n" );
							return ret;
						}
					}
				}
			}
		}

		if( flgNonError == true ){
			flgFileOpenOk = pSampleSetNew->openFile( "", NULL );	// SampleTreeBuilderSampleSetNXonOpenFile()Ă΂
		}else{
			// G[̂ŁAϊȂ
		}

		fclose(fp);
	}

	// ̏ǉƁAsvɂȂ(by c)
	if(( flgNonError == true )&&( flgFileOpenOk )){	// @date 2013/03/26 <Add> OKADA	// t@CI[vsAonOpenSample()ŃNbV ǉ
		SampleTreeBuilderSample  *pSampleNew = (*pSampleSetNew).getSample();
		kome::plugin::PluginCallTool::onOpenSample( *pSampleNew );
	
		if( flgFileOpenOk ){
			// t@Cɏo͂ݒ
			kome::objects::ActiveObjectsManager& aoMgr = kome::objects::ActiveObjectsManager::getInstance();	// manager
			aoMgr.setActiveSample( pSampleNew );
		}
	}

	if(( flgNonError == true )&&( flgFileOpenOk == true )){
		ret.prim.boolVal = true;
	}else{
		ret.prim.boolVal = false;
	}

	return ret;
}
