/**
 * @file NetWorkCtrl
 * @brief NetWorkCtrl
 *
 * @author M.Fukuda
 * @date 2013.04.24
 *
 * Copyright(C) 2006-2014 Eisai Co., Ltd. All rights reserved.
 */

#pragma once

namespace kome {
	namespace massbank {

		class NetWorkCtrl {
		public:
			NetWorkCtrl();
			~NetWorkCtrl(){}

		private:
			// WSDL
			kome::net::Wsdl m_wsdl; // wdsl
			std::string url_;       // massbank URL
			std::string proxy_;     // proxy
			bool useNetFg_;         // networkgۂ
			bool changedFg_;        // ύX_ۂ
			bool showNG_;           // ڑs̌xoۂ
			bool hasExFg_;          // Exn̖߂ɐڑ悪ΉĂ邩ۂ

		public:
			// Getter
			bool hasEx(void) const {return hasExFg_;}

			// ڑmF
			const bool checkMyConnect(bool showNGFg = false);

			// method, xmlStr̓e MassBankAPIsB
			// ʂ resɋAĂ
			const bool execAPI(
				const std::string& method,
				std::string& xmlStr,
				std::vector<char>& refRes,
				int& errCode
				);

		private:
			// lbg[N(parameter.ini)̕ύXĎB
			// ݂ Proxymassbank url̂
			const bool onCheckNewInfoChanged();

			// WdsľʂoĂ
			const bool onWsdlConnectControler();

			// Wdsl url_ ŐڑĂ݂
			bool onLoadWsdl();

			// SOAP̑Ή֌W𒲂ׂ
			const bool onCheckSOAP(
				const std::string& method
				);
		};
	}
}
