/**
* @file SampleReaderWrapper.cpp
* @brief Sample Reader Wrapper
* @author OKADA, H.
* @date 2012/07/18
* Copyright (C) 2014 Shimadzu Corporation All rights reserved.
* <⑫>
*/


#include "SampleReaderWrapper.h"
#include "ClrObjectTool.h"

using kome::clr::SampleReaderWrapper;

// constructor
SampleReaderWrapper::SampleReaderWrapper( kome::objects::SampleReader& sample_reader ) : m_sampleReader(sample_reader) {
}


// destructor
SampleReaderWrapper::~SampleReaderWrapper(){
}


// sampleReaderԂ܂
kome::objects::SampleReader&  SampleReaderWrapper::getSampleReader(){
	return m_sampleReader;
}


// SampleReader IuWFNg selectKeys ĂяoB
System::String^ SampleReaderWrapper::selectKeys( void ){
	return ClrObjectTool::convertString( m_sampleReader.selectKeys().c_str(), "" );
};


// SampleReader IuWFNg openData ĂяoB
kome::clr::SampleWrapper^ SampleReaderWrapper::openData( System::String^ strKey ){
	return ClrObjectTool::createSampleWrapper(m_sampleReader.openData( ClrObjectTool::convertString( strKey )	));
};

