package com.wiki.standalone.moxkiriya.util;

import java.util.ArrayList;

/**
 * File種別を判定する。
 */
public class FileTypeDeterminator {
	/**
	 * 画像ファイルと判定する拡張子のリスト
	 */
	private final static ArrayList<String> imageExtensionList = new ArrayList<String>() {
		private static final long serialVersionUID = 1L;
		{ add(".jpg"); }
		{ add(".png"); }
		{ add(".gif"); }
	};
	
	/**
	 * ファイルが画像ファイルか判定する。
	 * @param filename
	 * @return 画像ファイルかどうか
	 */
	public static boolean isImageFile(String filename) {
		boolean isImage   = false;
		
		if(filename.contains(".") == true) {
			String  extension = filename.substring(filename.lastIndexOf("."));
	
			for(String key: imageExtensionList) {
				if(extension.equalsIgnoreCase(key) == true) {
					isImage = true;
					break;
				}
			}
		}

		return isImage;
	}
}
