/**
 * Moxkiriya standalone Wiki.
 * File IO utility.
 * 
 * @author Ryuhei Terada
 * See the '<a href="{@docRoot}/copyright.html">Copyright</a>'
 */
package com.wiki.standalone.moxkiriya.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;

/**
 * ファイル IO utilityクラス
 *
 */
public class FileIO {
	/**
	 * バッファreaderを生成する。文字セットは"UTF-8"を指定する。
	 * @param stringReader
	 * @return　生成したバッファreader
	 * @throws Exception
	 */
	public static BufferedReader bufferedReader(StringReader stringReader)
			throws Exception {
		return new BufferedReader(stringReader);
	}

	/**
	 * バッファreaderを生成する。文字セットは"UTF-8"を指定する。
	 * @param pathname
	 * @return　生成したバッファreader
	 * @throws Exception
	 */
	public static BufferedReader bufferedReader(String pathname)
			throws Exception {
		return bufferedReader(pathname, "UTF-8");
	}

	/**
	 * charsetNameで指定された文字セットのバッファreaderを生成する
	 * @param pathname
	 * @param charsetName
	 * @return　生成したバッファreader
	 * @throws Exception
	 */
	public static BufferedReader bufferedReader(String pathname, String charsetName)
			throws Exception {
		return bufferedReader(new File(pathname), charsetName);
	}

	/**
	 * バッファreaderを生成する。文字セットは"UTF-8"を指定する。
	 * @param file
	 * @return　生成したバッファreader
	 * @throws Exception
	 */
	public static BufferedReader bufferedReader(File file)
			throws Exception {
		return bufferedReader(file, "UTF-8");
	}

	/**
	 * charsetNameで指定された文字セットのバッファreaderを生成する。
	 * @param file
	 * @param charsetName
	 * @return　生成したバッファreader
	 * @throws Exception
	 */
	public static BufferedReader bufferedReader(File file, String charsetName)
			throws Exception {
		BufferedReader    reader = null;
		if(file.exists() == true) {
			FileInputStream   inputStream   = new FileInputStream(file);
			InputStreamReader streamReader  = new InputStreamReader(inputStream, charsetName);
			reader = new BufferedReader(streamReader);
		}
		
		return reader;
	}

	/**
	 * バッファwriterを生成する。文字セットは"UTF-8"を指定する。
	 * @param pathname
	 * @return　生成したバッファwriter
	 * @throws Exception
	 */
	public static BufferedWriter bufferedWriter(String pathname)
			throws Exception {
		return bufferedWriter(pathname, "UTF-8");
	}

	/**
	 * charsetNameで指定された文字セットのバッファwriterを生成する
	 * @param pathname
	 * @param charsetName
	 * @return　生成したバッファwriter
	 * @throws Exception
	 */
	public static BufferedWriter bufferedWriter(String pathname, String charsetName)
			throws Exception {
		return bufferedWriter(new File(pathname), charsetName);
	}

	/**
	 * バッファwriterを生成する。文字セットは"UTF-8"を指定する。
	 * @param file
	 * @return　生成したバッファwriter
	 * @throws Exception
	 */
	public static BufferedWriter bufferedWriter(File file)
			throws Exception {
		return bufferedWriter(file, "UTF-8");
	}

	/**
	 * charsetNameで指定された文字セットのバッファwriterを生成する。
	 * @param file
	 * @param charsetName
	 * @return　生成したバッファwriter
	 * @throws Exception
	 */
	public static BufferedWriter bufferedWriter(File file, String charsetName)
			throws Exception {
		BufferedWriter    writer = null;
		if(file.exists() != true) {
			file.createNewFile();
		}

		FileOutputStream  outputStream  = new FileOutputStream(file);
		OutputStreamWriter streamReader = new OutputStreamWriter(outputStream, charsetName);
		writer = new BufferedWriter(streamReader);
		
		return writer;
	}

}
