package com.wiki.standalone.moxkiriya.parser.inlineparser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.wiki.standalone.moxkiriya.WikiEngine;

public class WikiOrderedListItemInlineParser extends WikiInlineParserBase {
	/** WIKIトークン */
	public static final String WIKI_TOKEN    = "# ";

	/** WIKI記法の正規表現文字列　先頭頭パターン */
	public static final String PATTERN_START = "^[ \t]*# ";

	/** WIKI記法の正規表現文字列　末尾パターン */
	public static final String PATTERN_END = "$";

	/** 開始タグ */
	private static final String START_TAG = "<li>";

	/** 終了タグ */
	private static final String END_TAG   = "</li>\n";
	
	/**
	 * コンストラクタ
	 */
	public WikiOrderedListItemInlineParser(WikiEngine wikiEngine) {
		super(wikiEngine);
	}

	/**
	 * lineとWiki記法をマッチングする
	 * @param line
	 * @return マッチング結果
	 */
	public static boolean matches(String line) {
		Matcher startMatcher
			= Pattern.compile(WikiOrderedListItemInlineParser.PATTERN_START).matcher(line);

		return startMatcher.find();
	}

	@Override
	public void startElementProcess(StringBuffer buf) {
		buf.append(START_TAG);
	}

	@Override
	public void endElementProcess(StringBuffer buf) {
		buf.append(END_TAG);
	}

	@Override
	public String deleteWikiToken(String line) {
		return line.replaceFirst(WIKI_TOKEN, "");
	}

	@Override
	public String getStartPattern() {
		return PATTERN_START;
	}

	@Override
	public String getEndPattern() {
		return PATTERN_END;
	}
}
