/**
 * 
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;

/**
 * Default block parser.
 *
 */
public class WikiDefaultBlockParser extends WikiBlockParserBase {
	/** 
	 *　 コンストラクタ
	 * @param wikiRepository
	 */
	public WikiDefaultBlockParser(WikiEngine wikiEngine) {
		super(wikiEngine);
	}	

	@Override
	public String startElementProcess(String line, StringBuffer buf) {
		return line;
	}

	@Override
	public String parse(String line, StringBuffer buf) throws Exception {
		buf.append("<div>");
		buf.append(inlineParse(line));
		buf.append("</div>\n");
		return "";
	}

	@Override
	public String endElementProcess(String line, StringBuffer buf) {
		return "";
	}


	@Override
	public boolean isBlockEnd() {
		return true;
	}
}
