/**
 * DialogControllerベースクラス
 * @author Ryuhei Terada
 */
package com.wiki.standalone.moxkiriya.dialog;

import java.net.URL;
import java.util.ResourceBundle;


/**
 * DialogControllerBase
 */
public abstract class DialogControllerBase implements DialogController {
	/** URL */
	URL url_;
	
	/** Resource Bundle */
	protected ResourceBundle resource_;

	@Override
	public void initialize(URL url, ResourceBundle resource) {
		url_      = url;
		resource_ = resource;
	}

	/**
	 * 終了種別を取得する。
	 * @param closeType
	 */
	public DialogBase.CloseType getCloseType() {
		return DialogBase.CloseType.OK;
	}
}
