/**
 * AlertDialog
 * @author Ryuhei Terada
 */
package com.wiki.standalone.moxkiriya.dialog;

import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

/**
 * AlertDialog
 *
 */
public class AlertDialog extends DialogBase {
	/**
	 * Message種別列挙定数
	 */
	public enum MessageType {
		ConfirmEditCancel,	// 編集キャンセル確認ダイアログ	
		AlertTitleEmpty,	// Title未入力警告ダイアログ
		SuccessImport,		// Import成功情報ダイアログ
		FailureImport,		// Import失敗情報ダイアログ
		SuccessExport,		// Export成功情報ダイアログ
		FailureExport,		// Export失敗情報ダイアログ
	};
	
	/**
	 * Dialog種別列挙定数
	 */
	public enum DialogType {
		Error,	// エラーダイアログ
		Alert,	// 警告ダイアログ
		Info,	// 情報ダイアログ
		Confirm	// 確認ダイアログ
	};

	/**
	 * Button種別列挙定数
	 */
	public enum ButtoType {
		OK,
		CANCEL_OK
	}
	
	/**
	 * メッセージタイプ
	 */
	private MessageType msgType_;


	/**
	 * コンストラクタ
	 * @param msgType
	 */
	public AlertDialog(MessageType msgType) {
		msgType_ = msgType;
		Stage       stage       = new Stage(StageStyle.UTILITY);
		stage.initOwner(parentStage_);
		stage.initModality(Modality.WINDOW_MODAL);
	}
	
	@Override
	protected String getFXML() {
		return "AlertDialog.fxml";
	}

	@Override
	protected DialogController getController() throws Exception {
		AlertDialogController controller = loader_.getController();
		controller.setMessageType(msgType_);
		
		return controller;
	}

	@Override
	protected CloseType getCloseType() {
		return ((AlertDialogController)controller_).getCloseType();
	}
}