/**
 * Moxkiriya standalone Wiki.
 * Wiki Help window.
 * 
 * @author Ryuhei Terada
 * See the '<a href="{@docRoot}/copyright.html">Copyright</a>'
 */
package com.wiki.standalone.moxkiriya;

import java.util.ResourceBundle;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

/**
 * Show preview editing content.
 *
 */
public class WikiHelpWindow {
	/** mother stage. */
	private Stage motherStage_ = null;

	/** Resource Bundle */
	private ResourceBundle resources_ = null;

	/** Stage */
	private Stage stage_;

	/** Help window controller */
	private WikiHelpWindowController controller_;

	/** Main window controller */
	private WikiMainWindowController mainController_;

	/**
	 * Status of preview window.
	 *
	 */
	private enum HelpWindowStatus {
		SHOW,
		HIDE
	};

	/** Help window status */
	private HelpWindowStatus helpWindowStatus_ = HelpWindowStatus.HIDE; 
	
	/**
	 * Constructor.
	 */
	public WikiHelpWindow(Stage motherStage, ResourceBundle resources) {
		motherStage_ = motherStage;
		resources_   = resources;

		try {
			FXMLLoader loader = new FXMLLoader(getClass().getResource("WikiHelpWindow.fxml"), resources_);
			loader.load();

			Scene scene  = new Scene((Parent)loader.getRoot());
			scene.getStylesheets().add(getClass().getResource("application.css").toExternalForm());

			controller_ = loader.getController();
			controller_.setWikiHelpWindow(this);

			stage_  = new Stage(StageStyle.DECORATED);
			stage_.initOwner(motherStage_);
			stage_.setScene(scene);
			stage_.setTitle(resources_.getString("key.HelpWindow.Title"));
			stage_.setResizable(true);
			stage_.showingProperty().addListener(new ChangeListener<Boolean>() {
				@Override
				public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
					helpWindowStatus_ = newValue == false
							? HelpWindowStatus.HIDE
							: HelpWindowStatus.SHOW;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Main windowController setter.
	 * @param mainController
	 */
	public void setMainWindowController(WikiMainWindowController mainController) {
		mainController_ = mainController;
	}

	/**
	 * Wiki repository setter.
	 * @param wikiRepository
	 */
	public void setWikiRepository(WikiRepository wikiRepository) {
		controller_.setWikiRepository(wikiRepository);
	}

	/**
	 * Latest contents getter.
	 * @return PageData
	 * @throws Exception 
	 */
	public PageData getLatestContents() throws Exception {
		return mainController_.getLatestContents();
	}
	
	/**
	 * Show Wiki preview window
	 * @throws Exception
	 */
	public void show() throws Exception {
//		controller_.loadWikiContent(mainController_.getLatestContents());
		controller_.loadTableOfContent();
		if(helpWindowStatus_ == HelpWindowStatus.HIDE) {
			stage_.show();				
		} else {
//			controller_.loadWikiContent(mainController_.getLatestContents());
		}
	}

	/**
	 * Hide Wiki preview window
	 */
	public void hide() {
		stage_.hide();
	}
}
