/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication.token;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.core.security.user.UserImpl;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompatTokenProvider {
    private static final Logger log = LoggerFactory.getLogger(CompatTokenProvider.class);
    private static final String TOKEN_ATTRIBUTE = ".token";
    private static final String TOKEN_ATTRIBUTE_EXPIRY = ".token.exp";
    private static final String TOKEN_ATTRIBUTE_KEY = ".token.key";
    private static final String TOKENS_NODE_NAME = ".tokens";
    private static final String TOKENS_NT_NAME = "nt:unstructured";
    private static final char DELIM = '_';
    private final SessionImpl session;
    private final UserManager userManager;
    private final long tokenExpiration;

    CompatTokenProvider(SessionImpl session, long tokenExpiration) throws RepositoryException {
        this.session = session;
        this.userManager = session.getUserManager();
        this.tokenExpiration = tokenExpiration;
    }

    public TokenInfo createToken(User user, SimpleCredentials sc) throws RepositoryException {
        String userPath = null;
        Principal pr = user.getPrincipal();
        if (pr instanceof ItemBasedPrincipal) {
            userPath = ((ItemBasedPrincipal)pr).getPath();
        }
        if (userPath != null && this.session.nodeExists(userPath)) {
            Node userNode = this.session.getNode(userPath);
            if (!userNode.hasNode(TOKENS_NODE_NAME)) {
                userNode.addNode(TOKENS_NODE_NAME, TOKENS_NT_NAME);
                try {
                    this.session.save();
                }
                catch (RepositoryException e) {
                    this.session.refresh(false);
                }
            }
            Node tokenParent = userNode.getNode(TOKENS_NODE_NAME);
            long creationTime = new Date().getTime();
            long expirationTime = creationTime + this.tokenExpiration;
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTimeInMillis(creationTime);
            String key = CompatTokenProvider.generateKey(8);
            String tokenName = Text.replace((String)ISO8601.format((Calendar)cal), (String)":", (String)".");
            Node tokenNode = System.getProperty("jackrabbit.sequentialNodeId") == null ? tokenParent.addNode(tokenName) : ((NodeImpl)tokenParent).addNodeWithUuid(tokenName, NodeId.randomId().toString());
            StringBuilder sb = new StringBuilder(tokenNode.getIdentifier());
            sb.append('_').append(key);
            String token = sb.toString();
            TokenCredentials tokenCredentials = new TokenCredentials(token);
            sc.setAttribute(TOKEN_ATTRIBUTE, (Object)token);
            tokenNode.setProperty(TOKEN_ATTRIBUTE_KEY, CompatTokenProvider.getDigestedKey(key));
            cal.setTimeInMillis(expirationTime);
            tokenNode.setProperty(TOKEN_ATTRIBUTE_EXPIRY, this.session.getValueFactory().createValue(cal));
            for (String name : sc.getAttributeNames()) {
                if (TOKEN_ATTRIBUTE.equals(name)) continue;
                String value = sc.getAttribute(name).toString();
                tokenNode.setProperty(name, value);
                tokenCredentials.setAttribute(name, value);
            }
            this.session.save();
            return new CompatModeInfo(token, tokenNode);
        }
        throw new RepositoryException("Cannot create login token: No corresponding node for User " + user.getID() + " in workspace '" + this.session.getWorkspace().getName() + "'.");
    }

    public TokenInfo getTokenInfo(String token) throws RepositoryException {
        if (token == null) {
            return null;
        }
        NodeImpl tokenNode = (NodeImpl)CompatTokenProvider.getTokenNode(token, (Session)this.session);
        String userId = CompatTokenProvider.getUserId(tokenNode, this.userManager);
        if (userId == null || !CompatTokenProvider.isValidTokenTree(tokenNode)) {
            return null;
        }
        return new CompatModeInfo(token);
    }

    static Node getTokenNode(String token, Session session) throws RepositoryException {
        int pos = token.indexOf(95);
        String id = pos == -1 ? token : token.substring(0, pos);
        return session.getNodeByIdentifier(id);
    }

    public static String getUserId(TokenCredentials tokenCredentials, Session session) throws RepositoryException {
        if (!(session instanceof JackrabbitSession)) {
            throw new RepositoryException("JackrabbitSession expected");
        }
        NodeImpl n = (NodeImpl)CompatTokenProvider.getTokenNode(tokenCredentials.getToken(), session);
        return CompatTokenProvider.getUserId(n, ((JackrabbitSession)session).getUserManager());
    }

    private static String getUserId(NodeImpl tokenNode, UserManager userManager) throws RepositoryException {
        if (tokenNode != null) {
            final NodeImpl userNode = (NodeImpl)tokenNode.getParent().getParent();
            final String principalName = userNode.getProperty(UserImpl.P_PRINCIPAL_NAME).getString();
            if (userNode.isNodeType(UserImpl.NT_REP_USER)) {
                Authorizable a = userManager.getAuthorizable((Principal)new ItemBasedPrincipal(){

                    public String getPath() throws RepositoryException {
                        return userNode.getPath();
                    }

                    public String getName() {
                        return principalName;
                    }
                });
                if (a != null && !a.isGroup() && !((User)a).isDisabled()) {
                    return a.getID();
                }
            } else {
                throw new RepositoryException("Failed to calculate userId from token credentials");
            }
        }
        return null;
    }

    static boolean isMandatoryAttribute(String attributeName) {
        return attributeName != null && attributeName.startsWith(TOKEN_ATTRIBUTE);
    }

    private static boolean isInfoAttribute(String propertyName) {
        String prefix = Text.getNamespacePrefix((String)propertyName);
        return !"jcr".equals(prefix) && !"rep".equals(prefix);
    }

    private static boolean isValidTokenTree(NodeImpl tokenNode) throws RepositoryException {
        if (tokenNode == null) {
            return false;
        }
        return TOKENS_NODE_NAME.equals(tokenNode.getParent().getName());
    }

    private static String generateKey(int size) {
        SecureRandom random = new SecureRandom();
        byte[] key = new byte[size];
        random.nextBytes(key);
        StringBuffer res = new StringBuffer(key.length * 2);
        for (byte b : key) {
            res.append(Text.hexTable[b >> 4 & 0xF]);
            res.append(Text.hexTable[b & 0xF]);
        }
        return res.toString();
    }

    private static String getDigestedKey(TokenCredentials tc) throws RepositoryException {
        String tk = tc.getToken();
        int pos = tk.indexOf(95);
        if (pos > -1) {
            return CompatTokenProvider.getDigestedKey(tk.substring(pos + 1));
        }
        return null;
    }

    private static String getDigestedKey(String key) throws RepositoryException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append("sha1").append("}");
            sb.append(Text.digest((String)"sha1", (String)key, (String)"UTF-8"));
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException("Failed to generate login token.");
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("Failed to generate login token.");
        }
    }

    private final class CompatModeInfo
    implements TokenInfo {
        private final String token;
        private final Map<String, String> attributes;
        private final Map<String, String> info;
        private final long expiry;
        private final String key;

        private CompatModeInfo(String token) throws RepositoryException {
            this(token, CompatTokenProvider.getTokenNode(token, (Session)compatTokenProvider.session));
        }

        private CompatModeInfo(String token, Node n) throws RepositoryException {
            this.token = token;
            long expTime = Long.MAX_VALUE;
            String keyV = null;
            if (token != null) {
                this.attributes = new HashMap<String, String>();
                this.info = new HashMap<String, String>();
                PropertyIterator it = n.getProperties();
                while (it.hasNext()) {
                    Property p = it.nextProperty();
                    String name = p.getName();
                    if (CompatTokenProvider.TOKEN_ATTRIBUTE_EXPIRY.equals(name)) {
                        expTime = p.getLong();
                        continue;
                    }
                    if (CompatTokenProvider.TOKEN_ATTRIBUTE_KEY.equals(name)) {
                        keyV = p.getString();
                        continue;
                    }
                    if (CompatTokenProvider.isMandatoryAttribute(name)) {
                        this.attributes.put(name, p.getString());
                        continue;
                    }
                    if (!CompatTokenProvider.isInfoAttribute(name)) continue;
                    this.info.put(name, p.getString());
                }
            } else {
                this.attributes = Collections.emptyMap();
                this.info = Collections.emptyMap();
            }
            this.expiry = expTime;
            this.key = keyV;
        }

        @Override
        public String getToken() {
            return this.token;
        }

        @Override
        public boolean isExpired(long loginTime) {
            return this.expiry < loginTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove() {
            Session s = null;
            try {
                s = CompatTokenProvider.this.session.createSession(CompatTokenProvider.this.session.getWorkspace().getName());
                Node tokenNode = CompatTokenProvider.getTokenNode(this.token, s);
                tokenNode.remove();
                s.save();
                boolean bl = true;
                return bl;
            }
            catch (RepositoryException e) {
                log.warn("Internal error while removing token node.", (Throwable)e);
            }
            finally {
                if (s != null) {
                    s.logout();
                }
            }
            return false;
        }

        @Override
        public boolean matches(TokenCredentials tokenCredentials) throws RepositoryException {
            if (this.key != null && !this.key.equals(CompatTokenProvider.getDigestedKey(tokenCredentials))) {
                return false;
            }
            for (String name : this.attributes.keySet()) {
                if (this.attributes.get(name).equals(tokenCredentials.getAttribute(name))) continue;
                return false;
            }
            List<String> attrNames = Arrays.asList(tokenCredentials.getAttributeNames());
            for (String key : this.info.keySet()) {
                if (attrNames.contains(key)) continue;
                tokenCredentials.setAttribute(key, this.info.get(key));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean resetExpiration(long loginTime) throws RepositoryException {
            Session s = null;
            try {
                if (this.expiry - loginTime <= CompatTokenProvider.this.tokenExpiration / 2L) {
                    long expirationTime = loginTime + CompatTokenProvider.this.tokenExpiration;
                    Calendar cal = GregorianCalendar.getInstance();
                    cal.setTimeInMillis(expirationTime);
                    s = CompatTokenProvider.this.session.createSession(CompatTokenProvider.this.session.getWorkspace().getName());
                    Node tokenNode = CompatTokenProvider.getTokenNode(this.token, s);
                    tokenNode.setProperty(CompatTokenProvider.TOKEN_ATTRIBUTE_EXPIRY, s.getValueFactory().createValue(cal));
                    s.save();
                    boolean bl = true;
                    return bl;
                }
            }
            catch (RepositoryException e) {
                log.warn("Failed to update expiry or informative attributes of token node.", (Throwable)e);
            }
            finally {
                if (s != null) {
                    s.logout();
                }
            }
            return false;
        }

        @Override
        public TokenCredentials getCredentials() {
            TokenCredentials tc = new TokenCredentials(this.token);
            for (String name : this.attributes.keySet()) {
                tc.setAttribute(name, this.attributes.get(name));
            }
            for (String name : this.info.keySet()) {
                tc.setAttribute(name, this.info.get(name));
            }
            return tc;
        }
    }
}

