/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.core.ItemData;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.ItemRefreshOperation;
import org.apache.jackrabbit.core.ItemRemoveOperation;
import org.apache.jackrabbit.core.ItemSaveOperation;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.value.ValueHelper;

public abstract class ItemImpl
implements Item {
    protected static final int STATUS_NORMAL = 0;
    protected static final int STATUS_MODIFIED = 1;
    protected static final int STATUS_DESTROYED = 2;
    protected static final int STATUS_INVALIDATED = 3;
    protected final ItemId id;
    protected final SessionContext sessionContext;
    protected final ItemData data;
    protected final ItemManager itemMgr;
    protected final SessionItemStateManager stateMgr;

    ItemImpl(ItemManager itemMgr, SessionContext sessionContext, ItemData data) {
        this.sessionContext = sessionContext;
        this.stateMgr = sessionContext.getItemStateManager();
        this.id = data.getId();
        this.itemMgr = itemMgr;
        this.data = data;
    }

    protected <T> T perform(SessionOperation<T> operation) throws RepositoryException {
        this.itemSanityCheck();
        return this.sessionContext.getSessionState().perform(operation);
    }

    protected void sanityCheck() throws RepositoryException {
        this.sessionContext.getSessionState().checkAlive();
        this.itemSanityCheck();
    }

    protected void itemSanityCheck() throws RepositoryException {
        int status = this.data.getStatus();
        if (status == 2 || status == 3) {
            throw new InvalidItemStateException("Item does not exist anymore: " + this.id);
        }
    }

    protected boolean isTransient() {
        return this.getItemState().isTransient();
    }

    protected abstract ItemState getOrCreateTransientItemState() throws RepositoryException;

    protected abstract void makePersistent() throws RepositoryException;

    protected void setRemoved() throws RepositoryException {
        int status = this.data.getStatus();
        if (status == 3 || status == 2) {
            return;
        }
        ItemState transientState = this.getOrCreateTransientItemState();
        if (transientState.getStatus() == 4) {
            this.stateMgr.disposeTransientItemState(transientState);
        } else {
            transientState.setStatus(3);
            this.stateMgr.moveTransientItemStateToAttic(transientState);
            this.data.setStatus(3);
            this.itemMgr.itemInvalidated(this.id, this.data);
        }
    }

    ItemState getItemState() {
        return this.data.getState();
    }

    public ItemId getId() {
        return this.id;
    }

    public Path getPrimaryPath() throws RepositoryException {
        return this.sessionContext.getHierarchyManager().getPath(this.id);
    }

    public String safeGetJCRPath() {
        return this.itemMgr.safeGetJCRPath(this.id);
    }

    public abstract Name getQName() throws RepositoryException;

    protected Name getQName(String name) throws RepositoryException {
        return this.sessionContext.getQName(name);
    }

    protected ValueFactory getValueFactory() throws RepositoryException {
        return this.getSession().getValueFactory();
    }

    protected Value[] getValues(String[] values, int type) throws RepositoryException {
        if (values != null) {
            return ValueHelper.convert((String[])values, (int)type, (ValueFactory)this.getValueFactory());
        }
        return null;
    }

    protected int getType(Value[] values) {
        if (values != null) {
            for (Value value : values) {
                if (value == null) continue;
                return value.getType();
            }
        }
        return 0;
    }

    public abstract void accept(ItemVisitor var1) throws RepositoryException;

    public abstract boolean isNode();

    public abstract String getName() throws RepositoryException;

    public abstract Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException;

    public boolean isNew() {
        ItemState state = this.getItemState();
        return state.isTransient() && state.getOverlayedState() == null;
    }

    protected boolean isTransactionalNew() {
        ItemState state = this.getItemState();
        return state.getStatus() == 4;
    }

    public boolean isModified() {
        ItemState state = this.getItemState();
        return state.isTransient() && state.getOverlayedState() != null;
    }

    public void remove() throws RepositoryException {
        this.perform(new ItemRemoveOperation(this, true));
    }

    public void save() throws RepositoryException {
        this.perform(new ItemSaveOperation(this.getItemState()));
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.perform(new ItemRefreshOperation(this.getItemState(), keepChanges));
    }

    public Item getAncestor(final int degree) throws RepositoryException {
        return this.perform(new SessionOperation<Item>(){

            @Override
            public Item perform(SessionContext context) throws RepositoryException {
                if (degree == 0) {
                    return context.getItemManager().getRootNode();
                }
                try {
                    Path path = ItemImpl.this.getPrimaryPath();
                    int relDegree = path.getAncestorCount() - degree;
                    if (relDegree < 0) {
                        throw new ItemNotFoundException();
                    }
                    if (relDegree == 0) {
                        return ItemImpl.this;
                    }
                    Path ancestorPath = path.getAncestor(relDegree);
                    return context.getItemManager().getNode(ancestorPath);
                }
                catch (PathNotFoundException e) {
                    throw new ItemNotFoundException("Ancestor not found", (Throwable)e);
                }
            }

            public String toString() {
                return "item.getAncestor(" + degree + ")";
            }
        });
    }

    public String getPath() throws RepositoryException {
        return this.perform(new SessionOperation<String>(){

            @Override
            public String perform(SessionContext context) throws RepositoryException {
                return context.getJCRPath(ItemImpl.this.getPrimaryPath());
            }

            public String toString() {
                return "item.getPath()";
            }
        });
    }

    public int getDepth() throws RepositoryException {
        return this.perform(new SessionOperation<Integer>(){

            @Override
            public Integer perform(SessionContext context) throws RepositoryException {
                ItemState state = ItemImpl.this.getItemState();
                if (state.getParentId() == null) {
                    return 0;
                }
                return context.getHierarchyManager().getDepth(ItemImpl.this.id);
            }

            public String toString() {
                return "item.getDepth()";
            }
        });
    }

    public Session getSession() {
        return this.sessionContext.getSessionImpl();
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        this.sanityCheck();
        if (this == otherItem) {
            return true;
        }
        if (otherItem instanceof ItemImpl) {
            ItemImpl other = (ItemImpl)otherItem;
            return this.id.equals(other.id) && this.getSession().getWorkspace().getName().equals(other.getSession().getWorkspace().getName());
        }
        return false;
    }

    public String toString() {
        return this.safeGetJCRPath();
    }
}

