/******************************************************************************/
/*                                                                            */
/* src/lib/libc/string/memcpy.c                                               */
/*                                                                 2019/07/24 */
/* Copyright (C) 2017-2019 Mochi.                                             */
/*                                                                            */
/******************************************************************************/
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 標準ヘッダ */
#include <stdint.h>
#include <string.h>


/******************************************************************************/
/* グローバル関数宣言                                                         */
/******************************************************************************/
/******************************************************************************/
/**
 * @brief       memcpy
 * @details     標準Cライブラリのmemcpy関数。
 *
 * @param[in]   *s1 コピー先
 * @param[in]   *s2 コピー元
 * @param[in]   n   コピーサイズ
 *
 * @return      コピー先アドレス
 */
/******************************************************************************/
void *memcpy( void       *s1,
              const void *s2,
              size_t     n    )
{
    /* 1バイト毎に終端バイトから繰り返し */
    while ( n > 0 ) {
        /* コピーサイズ更新 */
        n--;

        /* コピー値代入 */
        *( ( uint8_t * ) s1 + n ) = *( ( uint8_t * ) s2 + n );
    }

    return s1;
}


/******************************************************************************/
