/******************************************************************************/
/*                                                                            */
/* src/booter/InitCtrl/InitCtrl16.s                                           */
/*                                                                 2019/07/24 */
/* Copyright (C) 2016-2019 Mochi.                                             */
/*                                                                            */
/******************************************************************************/
 .intel_syntax noprefix
.code16
/******************************************************************************/
/* グローバル関数宣言                                                         */
/******************************************************************************/
.global InitCtrlInit16


/******************************************************************************/
/* 外部関数宣言                                                               */
/******************************************************************************/
.extern IntCtrlInit32


/******************************************************************************/
/* 外部変数宣言                                                               */
/******************************************************************************/
.extern gBiosE820EntryNum
.extern gBiosE820


/******************************************************************************/
/* TEXTセクション                                                             */
/******************************************************************************/
.section .text

InitCtrlInit16:
    /* 初期化 */
    xor         ax, ax
    mov         ds, ax
    mov         es, ax
    mov         fs, ax
    mov         gs, ax

    /* ビデオモード設定 */
    mov         ax, 0x0003
    int         0x10

    /* メモリマップ情報初期化 */
    mov         DWORD PTR [ gBiosE820EntryNum ], 0  /* メモリマップエントリ数 */
    mov         ebx, 0x00000000                     /* 継続値                 */
    mov         di, offset gBiosE820                /* 格納先アドレス         */

    /* メモリマップ取得 */
CallE820:
    mov         eax, 0x0000E820     /* 機能コード       */
    mov         ecx, 0x00000014     /* エントリサイズ   */
    mov         edx, 0x534D4150     /* シグネチャ(SMAP) */
    int         0x15                /* BIOS機能呼出し   */

    /* エラーチェック */
    jc          InitStop            /* キャリーフラグチェック   */
    cmp         eax, 0x534D4150     /* シグネチャ(SMAP)チェック */
    jne         InitStop
    cmp         ecx, 0x00000014     /* サイズチェック           */
    jne         InitStop

    /* メモリマップ情報更新 */
    inc         DWORD PTR [ gBiosE820EntryNum ] /* メモリマップエントリ数 */
    add         di, 0x0014                      /* 格納先アドレス         */

    /* 継続値チェック */
    cmp         ebx, 0x00000000
    jne         CallE820

    /* 割り込み無効化 */
    mov         al, 0xFF
    out         0xA1, al    /* PIC2割り込み無効化 */
    nop
    out         0x21, al    /* PIC1割り込み無効化 */
    cli                     /* CPU割り込み無効化  */

    /* GDT設定 */
    lgdt        [ gInitGdtr ]

    /* CR0レジスタ設定 */
    mov         eax, cr0
    or          eax, 0x00000001     /* PEビットON       */
    mov         cr0, eax            /* 保護モード有効化 */

    /* 保護モード移行（far jump） */
    jmp         0x8:InitSetSegment

.code32
InitSetSegment:
    /* データセグメント初期化 */
    mov         ax, 2 * 8
    mov         ds, ax
    mov         es, ax
    mov         fs, ax
    mov         gs, ax
    mov         ss, ax

    /* スタックポインタ変更 */
    mov         esp, 0x00007A00 - 4

    /* 保護モード初期化関数呼び出し */
    call        InitCtrlInit32

InitStop:
    cli
    hlt
    jmp         InitStop


/******************************************************************************/
/* DATAセクション                                                             */
/******************************************************************************/
.section .data
/* GDT */
.align 8
gInitGdt:
    .word   0x0000, 0x0000, 0x0000, 0x0000  /* ナルセグメント   */
    .word   0xFFFF, 0x0000, 0x9800, 0x00CF  /* コードセグメント */
    .word   0xFFFF, 0x0000, 0x9200, 0x00CF  /* データセグメント */

/* GDTR */
gInitGdtr:
    .word   . - gInitGdt - 1    /* リミット          */
    .long   gInitGdt            /* GDTベースアドレス */


/******************************************************************************/
