/******************************************************************************/
/*                                                                            */
/* kernel/timer.h                                                             */
/*                                                                 2019/07/28 */
/* Copyright (C) 2018-2019 Mochi.                                             */
/*                                                                            */
/******************************************************************************/
#ifndef __KERNEL_TIMER_H__
#define __KERNEL_TIMER_H__
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 標準ヘッダ */
#include <stddef.h>
#include <stdint.h>

/* カーネルヘッダ */
#include "config.h"
#include "types.h"


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/* タイマ割込み番号 */
#define MK_TIMER_INTNO MK_CONFIG_INTNO_TIMER

/* 機能ID */
#define MK_TIMER_FUNCID_SLEEP     ( 0x00000001 )    /**< スリープ */

/** タイマパラメータ */
typedef struct {
    uint32_t funcId;    /**< 機能ID         */
    MkRet_t  ret;       /**< 戻り値         */
    MkErr_t  err;       /**< エラー内容     */
    uint32_t usec;      /**< タイマ値(μ秒) */
} MkTimerParam_t;


/******************************************************************************/
#endif
