/******************************************************************************/
/*                                                                            */
/* kernel/thread.h                                                            */
/*                                                                 2019/08/26 */
/* Copyright (C) 2018-2019 Mochi.                                             */
/*                                                                            */
/******************************************************************************/
#ifndef __KERNEL_THREAD_H__
#define __KERNEL_THREAD_H__
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 標準ヘッダ */
#include <stddef.h>
#include <stdint.h>

/* カーネルヘッダ */
#include "config.h"
#include "types.h"


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/* スレッド管理割込み番号 */
#define MK_THREAD_INTNO MK_CONFIG_INTNO_THREAD

/* 機能ID */
#define MK_THREAD_FUNCID_CREATE ( 0x00000001 )    /**< スレッド生成 */

/** スレッドエントリ関数 */
typedef void ( *MkThreadFunc_t )( void *pArg );

/** スレッド管理機能パラメータ */
typedef struct {
    uint32_t       funcId;      /**< 機能ID                   */
    MkRet_t        ret;         /**< 戻り値                   */
    MkErr_t        err;         /**< エラー内容               */
    MkThreadFunc_t pFunc;       /**< スレッドエントリ関数     */
    void           *pArg;       /**< スレッドエントリ関数引数 */
    void           *pStackAddr; /**< スタック領域             */
    size_t         stackSize;   /**< スタックサイズ           */
    MkTaskId_t     taskId;      /**< タスクID                 */
} MkThreadParam_t;


/******************************************************************************/
#endif
