/******************************************************************************/
/*                                                                            */
/* kernel/message.h                                                           */
/*                                                                 2019/07/28 */
/* Copyright (C) 2018-2019 Mochi.                                             */
/*                                                                            */
/******************************************************************************/
#ifndef __KERNEL_MESSAGE_H__
#define __KERNEL_MESSAGE_H__
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 標準ヘッダ */
#include <stddef.h>
#include <stdint.h>

/* カーネルヘッダ */
#include "config.h"
#include "types.h"


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/** メッセージパッシング割込み番号 */
#define MK_MSG_INTNO MK_CONFIG_INTNO_MESSAGE

/** メッセージサイズ最大 */
#define MK_MSG_SIZE_MAX         ( 24576 )

/* 機能ID */
#define MK_MSG_FUNCID_RECEIVE   ( 0x00000001 )  /**< メッセージ受信 */
#define MK_MSG_FUNCID_SEND      ( 0x00000002 )  /**< メッセージ送信 */

/** メッセージ受信パラメータ */
typedef struct {
    MkTaskId_t src;             /**< 受信メッセージ送信元タスクID */
    void       *pBuffer;        /**< 受信バッファ                 */
    size_t     bufferSize;      /**< 受信バッファサイズ           */
    size_t     recvSize;        /**< 受信メッセージサイズ         */
} MkMsgParamRecv_t;

/** メッセージ送信パラメータ */
typedef struct {
    MkTaskId_t dst;             /**< 送信先タスクID       */
    void       *pMsg;           /**< 送信メッセージ格納先 */
    size_t     size;            /**< 送信メッセージサイズ */
} MkMsgParamSend_t;

/** メッセージパッシングパラメータ */
typedef struct {
    uint32_t funcId;            /**< 機能ID                   */
    MkRet_t  ret;               /**< 戻り値                   */
    MkErr_t  err;               /**< エラー内容               */
    union {                     /*----------------------------*/
        MkMsgParamRecv_t recv;  /**< メッセージ受信パラメータ */
        MkMsgParamSend_t send;  /**< メッセージ送信パラメータ */
    };                          /*----------------------------*/
} MkMsgParam_t;


/******************************************************************************/
#endif
