/******************************************************************************/
/*                                                                            */
/* kernel/interrupt.h                                                         */
/*                                                                 2019/08/30 */
/* Copyright (C) 2018-2019 Mochi.                                             */
/*                                                                            */
/******************************************************************************/
#ifndef __KERNEL_INTERRUPT_H__
#define __KERNEL_INTERRUPT_H__
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 標準ヘッダ */
#include <stdint.h>

/* カーネルヘッダ */
#include "types.h"


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/** ハードウェア割込み制御割込み番号 */
#define MK_INT_INTNO MK_CONFIG_INTNO_INTERRUPT

/* 機能ID */
#define MK_INT_FUNCID_START_MONITORING ( 0x00000001 )   /**< 割込み監視開始   */
#define MK_INT_FUNCID_STOP_MONITORING  ( 0x00000002 )   /**< 割込み監視停止   */
#define MK_INT_FUNCID_WAIT             ( 0x00000003 )   /**< 割込み待ち合わせ */
#define MK_INT_FUNCID_COMPLETE         ( 0x00000004 )   /**< 割込み完了       */
#define MK_INT_FUNCID_ENABLE           ( 0x00000005 )   /**< 割込み有効化     */
#define MK_INT_FUNCID_DISABLE          ( 0x00000006 )   /**< 割込み無効化     */

/** ハードウェア割込み制御パラメータ */
typedef struct {
    uint32_t funcId;    /**< 機能ID           */
    MkRet_t  ret;       /**< 戻り値           */
    MkErr_t  err;       /**< エラー内容       */
    union {
        uint8_t  irqNo; /**< IRQ番号          */
        uint32_t flag;  /**< 割込み発生フラグ */
    };
} MkIntParam_t;


/******************************************************************************/
#endif
