/******************************************************************************/
/* src/libraries/libc/string/memcpy.c                                         */
/*                                                                 2017/03/16 */
/* Copyright (C) 2017 Mochi.                                                  */
/******************************************************************************/
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
#include <stdint.h>
#include <string.h>


/******************************************************************************/
/* グローバル関数宣言                                                         */
/******************************************************************************/
/******************************************************************************/
/**
 * @brief       memcpy
 * @details     標準Cライブラリのmemcpy関数。
 * 
 * @param[in]   *s1 コピー先
 * @param[in]   *s2 コピー元
 * @param[in]   n   コピーサイズ
 * 
 * @retval      コピー先アドレス
 */
/******************************************************************************/
void *memcpy( void       *s1,
              const void *s2,
              size_t     n    )
{
    /* 1バイト毎に終端バイトから繰り返し */
    while ( n > 0 ) {
        /* コピーサイズ更新 */
        n--;
        
        /* コピー値代入 */
        *( ( uint8_t * ) s1 + n ) = *( ( uint8_t * ) s2 + n );
    }
    
    return s1;
}


/******************************************************************************/
