/*******************************************************************************
 * booter/real_mode/a20.s
 *                                                                   2012/10/06
 * Copyright (C) 2012 Mochi
 ******************************************************************************/
.intel_syntax noprefix
.code16

.global enable_a20

.section .text
/*
 * A20ラインを有効にする
 * 戻り値:
 *    成功(ax = 0)
 *    失敗(ax = -1)
 */
enable_a20:
	/* A20ラインチェック */
	call	check_a20
	cmp		ax, 0
	je		enable_a20_1
	
	/* System Port Aを用いて有効化 */
	in		al, 0x92
	or		al, 0x02		/* 有効化 */
	and		al, 0xFE		/* リセットを確実に防ぐ */
	out		0x92, al		/* 設定 */
	
	/* A20ラインチェック */
	call	check_a20
	cmp		ax, 0
	je		enable_a20_1
	
	/* キーボードコントローラを用いて有効化 */
	call	wait_kbc
	mov		al, 0xD1
	out		0x64, al		/* ポート2書込みコマンド */
	call	wait_kbc
	mov		al, 0xDF
	out		0x60, al		/* 有効化 */
	call	wait_kbc
	
	/* A20ラインチェック */
	call	check_a20
	cmp		ax, 0
	je		enable_a20_1
	
	/* BIOSを用いて有効化 */
	mov		ax, 0x2401
	int		0x15
	
	/* A20ラインチェック */
	call	check_a20
	cmp		ax, 0
	je		enable_a20_1
	
	/* A20ライン有効化は失敗 */
	mov		ax, -1
enable_a20_1:
	/* A20ライン有効化は成功 */
	xor		ax, ax
	ret

/*
 * A20ラインが有効かチェックする
 * 戻り値:
 *    有効（ax = 0）
 *    無効（ax = -1）
 */
check_a20:
	/* アドレス0xFFFF:0x0010の値をバックアップ */
	xor		ax, ax
	mov		fs, ax
	mov		ax, [gs:0x10]
	push	ax
	
	/* アドレスFFFF:0010に値0xCODEを書き込む */
	mov		ax, 0xFFFF
	mov		gs, ax
	mov		word ptr [gs:0x10], 0xC0DE
	
	/* アドレス0000:0000の値を取得 */
	mov		bx, [fs:0]
	
	/* アドレス0xFFFF:0x0010にバックアップした値を書き込む */
	pop		ax
	mov		[gs:0x10], ax
	
	/* アドレス0000:0000の値と値0xCODEが等しいか */
	cmp		bx, 0xC0DE
	je		check_a20_1		/* 等しい */
	
	/* A20ラインは有効 */
	xor		ax, ax
	ret
check_a20_1:
	/* A20ラインは無効 */
	mov		ax, -1			/* 戻り値設定 */
	ret

/*
 * キーボードコントローラにコマンドが書込み可能になるまで待つ
 * （ループ毎にDELAYが必要か？伝統的な0x80番ポートへの
 * 書込みはハングアップする機種があるらしい）
 * 戻り値:
 *    なし
 */
wait_kbc:
	/* IBFをチェック */
	in		al, 0x64
	test	al,0x02
	jnz		wait_kbc
	
	ret
