/*******************************************************************************
 * booter/protected_mode/interrupt_handlers.s
 *                                                                   2012/10/07
 * Copyright (C) 2012 Mochi
 ******************************************************************************/
.intel_syntax noprefix
.code32

.global common_interrupt_handler
.global ata_interrupt_handler
.extern stop
.extern ata_intrq

.section .text
/*
 * 共通割込み処理
 */
common_interrupt_handler:
	/* 割込み無効化 */
	cli
	/* 停止 */
	call stop

/*
 * ATA-0割込み処理
 */
ata_interrupt_handler:
	/* 割込み無効化 */
	cli
	
	push	eax
	
	/* 割込み応答（EOI） */
	mov		al, 0x66
	out		0xA0, al
	mov		al, 0x62
	out		0x20, al
	
	/* ATA処理部へ割込み通知 */
	mov		eax, 1
	mov		dword ptr [ata_intrq], eax
	
	pop		eax
	
	/* 割込み有効化 */
	sti
	iretd
