//
// UIBoard.hpp
//

#pragma once

#include "UIBase.hpp"
#include "../ResourceManager.hpp"
#include <array>

class UIBoard : public UIBase {
    public:
        UIBoard();
        void ProcessInput(InputManager* input);
        void Update();
        void Draw();

        bool resizable() const;
        void set_resizable(bool resizable);

    public:
        static void DefineInstanceTemplate(Handle<ObjectTemplate>* object);

    private:
        void UpdateDrag(InputManager* input, bool resizeable = true);

    private:
        std::array<ImageHandle,4> base_image_handle_;

        bool resizable_;

        int max_width_, min_width_;
        int max_height_, min_height_;

        Rect drag_offset_rect_, drag_resize_offset_rect_;

    private:
        constexpr static int BASE_BLOCK_SIZE = 24;
};
