//
// Init.hpp
//

#pragma once

#include <memory>
#include "Base.hpp"
#include "../../common/network/Client.hpp"
#include "../LoginToken.hpp"
#include "../PlayerManager.hpp"
#include "../CardManager.hpp"
#include "../CommandManager.hpp"
#include "../WorldManager.hpp"
#include "../AccountManager.hpp"
#include "../ConfigManager.hpp"
#include "../ManagerAccessor.hpp"
#include "../ui/Input.hpp"

namespace scene {

class Init : public Base {

    public:
        Init();
        ~Init();
        void Begin();
        void Update();
        void Draw();
        void End();
        std::shared_ptr<BasePtr> NextScene();

    private:
        void AsyncInitialize();

    private:
        ManagerAccessorPtr manager_accesor_;
        ConfigManagerPtr config_manager_;
        CardManagerPtr card_manager_;
        AccountManagerPtr account_manager_;

        int start_count_;

        boost::thread loading_thread_;
        std::shared_ptr<BasePtr> next_scene_;

        std::array<ImageHandle, 5> loading_image_handle_;

        boost::mutex mutex_;
        bool loaded_;

        Input input_;
};

}
