//
// LoginToken.cpp
//

#include "LoginToken.hpp"
#include "../common/Logger.hpp"
#include "../common/network/Encrypter.hpp"
#include <DxLib.h>
#include <iostream>
#include <fstream>

LoginToken::LoginToken(const std::string& filename)
{
    std::ifstream ifs(filename.c_str(), std::ifstream::binary);

    if (!ifs) {
        ifs.close();
        GenerateFile(filename);

    } else {
        ifs.close();

        // イメージカードを読み込み
        int card_handle = LoadSoftImage(filename.c_str());
        if (card_handle == -1) {
            std::cout << "Error: Cannot open logincard." << std::endl;
        }

        std::string public_key;
        for (int i=0; i<256; i++) {
            int x = TOKEN_IMAGE_X + i % TOKEN_IMAGE_WIDTH;
            int y = TOKEN_IMAGE_Y + i / TOKEN_IMAGE_WIDTH;
            int b;
            GetPixelSoftImage(card_handle, x, y, nullptr, nullptr, &b, nullptr);
            public_key += static_cast<char>(b);
        }

        std::string private_key;
        for (int i=256; i<512; i++) {
            int x = TOKEN_IMAGE_X + i % TOKEN_IMAGE_WIDTH;
            int y = TOKEN_IMAGE_Y + i / TOKEN_IMAGE_WIDTH;
            int b;
            GetPixelSoftImage(card_handle, x, y, nullptr, nullptr, &b, nullptr);
            private_key += static_cast<char>(b);
        }

        DeleteSoftImage(card_handle);

        public_key_ = public_key;
        private_key_ = private_key;
    }
}

void LoginToken::GenerateFile(const std::string& filename)
{
    Logger::Error("Cannot open logincard template");

    network::Encrypter encrypter;
    public_key_ = encrypter.GetPublicKey();
    private_key_ = encrypter.GetPrivateKey();
    std::string out = public_key_ + private_key_;

    // ログインカードを出力
    int card_handle = LoadSoftImage(_T("resources/images/logincard.png"));
    if (card_handle == -1) {
        Logger::Error("Cannot read logincard");
        return;
    }

    int i = 0;
    for (const unsigned char& c : out) {
        int x = TOKEN_IMAGE_X + i % TOKEN_IMAGE_WIDTH;
        int y = TOKEN_IMAGE_Y + i / TOKEN_IMAGE_WIDTH;
        int r = 200 + y % 46;
        int g = 150 + x % 100;
        int b = static_cast<int>(c);
        int a = 255;
        DrawPixelSoftImage(card_handle, x, y, r, g, b, a);
        i++;
    }

    if (SaveSoftImageToPng(filename.c_str(), card_handle, 9) == -1) {
        Logger::Error("Cannot generate logincard");
    }
    DeleteSoftImage(card_handle);

}

std::string LoginToken::public_key()
{
    return public_key_;
}

std::string LoginToken::private_key()
{
    return private_key_;
}
