//
// Core.hpp
//

#pragma once

#include <DxLib.h>
#include "InputManager.hpp"
#include "scene/Include.hpp"
#include "../common/network/Client.hpp"

class Core {

    public:
        Core();
        int Run();

    private:
        void MainLoop();
        int SetUpDxLib();
        void SceneInit();
        void SetScene(scene::BasePtr);

        void LoadFont();

    private:
        scene::BasePtr current_scene_;

    private:
        constexpr const static char* CONFIG_PATH = "config.json";
        constexpr const static TCHAR* WINDOW_TITILE = _T("Miku Miku Online");
        constexpr const static TCHAR* FONT_FILE_PATH = _T("resources/fonts/umeplus-p-gothic.ttf");

};
