//
// FieldPlayer.hpp
//

#pragma once
#include "Character.hpp"
#include "CharacterManager.hpp"
#include "CharacterDataProvider.hpp"
#include "MotionPlayer.hpp"
#include "Timer.hpp"
#include "../InputManager.hpp"
#include "../ResourceManager.hpp"

class Stage;
typedef std::shared_ptr<Stage> StagePtr;

struct PlayerStatus
{
    VECTOR pos, vel, acc; // プレイヤーのマップ上での位置、速度、加速度
    float roty, roty_speed; // プレイヤーの鉛直軸周りの回転角
    int motion, prev_motion; // モーションの種類(BasicMotion::hoge)
    float blend_ratio; // モーションのブレンド比
    bool is_walking; // true:歩き, false:走り
};

// フィールド上のキャラクタ
class FieldPlayer : public Character
{
public:
    FieldPlayer(CharacterDataProvider& data_provider, const StagePtr& stage, const TimerPtr& timer);

    void Draw() const;
    void Update();
    void Init(tstring model_path);
    void ResetPosition();
    void RescuePosition();

    void SetModel(const std::string& name);

public:
    const ModelHandle& model_handle() const;
    const PlayerStatus& current_stat() const;
    float model_height() const;
    bool any_move() const;

    void LinkToCamera(float* roty);
    void UnlinkToCamera();
    void UpdateInput(InputManager* input);

private:
    void Move();
    void InputFromUser();

private:
    PlayerStatus prev_stat_, current_stat_;
    float model_height_;
    std::unique_ptr<MotionPlayer> motion_player_;
    TimerPtr timer_;

private:
    ModelHandle model_handle_;
    StagePtr stage_;
    bool any_move_;
    InputManager input_;

    struct {
        int stand_, walk_, run_;
    } motion;

    CharacterDataProvider& data_provider_;

    float* camera_roty_;
};
typedef std::shared_ptr<FieldPlayer> FieldPlayerPtr;
