//
// MMO Scanner
//

//
// Version
const int VERSION[] = {
        0, 1, 0, 0,             // Major
        0, 0, 0, 0              // Minor
};

#include <iostream>
#include <openssl/sha.h>
#include <boost/format.hpp>
#include <boost/filesystem.hpp>
#include "../../common/network/Utils.hpp"
#include "../../common/network/Downloader.hpp"
#include "../../common/database/SystemLog.hpp"
#include "../../common/database/CardLibrary.hpp"
#include "../Config.hpp"

using namespace boost::filesystem3;

std::string CheckFingerprint(const std::string filename)
{
    unsigned char c[SHA_DIGEST_LENGTH];
    FILE *inFile = fopen (filename.c_str(), "rb");
    SHA_CTX mdContext;
    int bytes;
    unsigned char data[1024];

    if (inFile == NULL) {
        return "";
    }

    SHA_Init (&mdContext);
    while ((bytes = fread (data, 1, 1024, inFile)) != 0)
        SHA_Update (&mdContext, data, bytes);
    SHA_Final (c,&mdContext);
    fclose (inFile);

    return std::string((char*)c, SHA_DIGEST_LENGTH);
}

void scan(CardLibrary& card, SystemLogPtr& sys_log) {

    // 設定を読み込み
    Config config("config.json");

    auto waiting = card.GetWaitingUrl();
    int id = waiting.first;
    const std::string& url = waiting.second;

    if (id < 0) {
        sys_log->Info("No Waiting URL.");
        return;
    }

    path downloaded_path = absolute(path(config.download_path())) / unique_path();

    std::string scan = config.scan_command();
    std::string scan_command = scan + downloaded_path.string();

    Downloader dl(url, 2000000);
    dl.SaveToFile(downloaded_path.string());

    switch (dl.status()) {
        case Downloader::COMPLETE:
        {
            sys_log->Info("Downloading Complete.");
            auto original_fingerprint = CheckFingerprint(downloaded_path.string());
            auto original_fingerprint_base64 = network::Utils::Base64Encode(original_fingerprint);
            sys_log->Info(original_fingerprint_base64);

            sys_log->Info("Scanning...");
            system(scan_command.c_str());
            auto scanned_fingerprint = CheckFingerprint(downloaded_path.string());

            if (original_fingerprint == scanned_fingerprint) {
                sys_log->Info("Pass Virus Scan.");
                auto size = file_size(downloaded_path);
                card.AcceptUrl(id, original_fingerprint_base64, size);
            } else {
                sys_log->Info("** Detected Virus **");
                card.RejectUrl(id);
            }
        }
            break;

        case Downloader::TOOLARGE:
        case Downloader::FAILED:
        {
            sys_log->Error("Downloading failed.");
            card.RejectUrl(id);
        }
            break;

        default:
            break;
    }

    if (exists(downloaded_path)) {
        remove(downloaded_path);
        sys_log->Info("Remove downloaded file.");
    }
}

int main(int argc, char* argv[])
{
    // システムログ
    SystemLogPtr sys_log = std::make_shared<SystemLog>(":memory:");

  try {

    // バージョン情報
    auto version = (boost::format("Start MMO Scanner  version: %d.%d.%d.%d.%d.%d.%d.%d")
      % VERSION[0] % VERSION[1] % VERSION[2] % VERSION[3]
      % VERSION[4] % VERSION[5] % VERSION[6] % VERSION[7]
    ).str();
    sys_log->Info(version);

    CardLibrary card("card.db");
    while(1) {
        scan(card, sys_log);
        sleep(10);
    }

  } catch (std::exception& e) {
      sys_log->Error(e.what());
  }

  return 0;
}
