//
// Server.hpp
//

#pragma once

#include <string>
#include <list>
#include <functional>
#include "Session.hpp"

namespace network {

class Server {
    private:
        class ServerSession : public Session {
            public:
                ServerSession(boost::asio::io_service& io_service, boost::asio::io_service& io_service_udp) :
                    Session(io_service) {};

                void Start();
        };

    public:
        Server(int);
        void Start(CallbackFuncPtr callback);
        void SendAll(const Command&);
        void SendOthers(const Command&, SessionWeakPtr);

        void UpdateUserList();
        int GetSessionReadAverageLimit();

        void SendUDPTestPacket(const std::string& ip_address, uint16_t port);

        int max_total_read_average() const;
        int max_session_read_average() const;
        int min_session_read_average() const;
        void set_max_total_read_average(int byte);
        void set_max_session_read_average(int byte);
        void set_min_session_read_average(int byte);

    private:
        void ReceiveSession(const SessionPtr&, const boost::system::error_code&);

    private:
       boost::asio::io_service io_service_;
       tcp::endpoint endpoint_;
       tcp::acceptor acceptor_;

       boost::asio::io_service io_service_udp_;
       udp::socket udp_socket_;

       CallbackFuncPtr callback_;

       int max_total_read_average_;
       int max_session_read_average_;
       int min_session_read_average_;
       int session_read_average_;

       boost::mutex mutex_;

       std::list<SessionWeakPtr> sessions_;

       static const int UDP_TEST_PACKET_TIME;
};

}
