//
// Downloader.hpp
//

#pragma once

#include <iostream>
#include <istream>
#include <fstream>
#include <string>
#include <boost/asio.hpp>
#include <boost/bind.hpp>

class Downloader {
    public:
        enum Status{
            STANDBY,
            DOWNLOADING,
            COMPLETE,
            TOOLARGE,
            FAILED
        };

    public:
        Downloader(const std::string& url,
                unsigned int max_length = 2000000);
        void SaveToFile(const std::string& filename);
        // TODO: ostreamを引数として渡すようにする

        Status status() const;

    private:
        void handle_resolve(const boost::system::error_code& err,
                boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

        void handle_connect(const boost::system::error_code& err);
        void handle_write_request(const boost::system::error_code& err);
        void handle_read_status_line(const boost::system::error_code& err);
        void handle_read_headers(const boost::system::error_code& err);
        void handle_read_content(const boost::system::error_code& err);

    private:
        boost::asio::io_service io_service_;
        boost::asio::ip::tcp::resolver resolver_;
        boost::asio::ip::tcp::socket socket_;
        boost::asio::streambuf request_;
        boost::asio::streambuf response_;

        std::string server_, path_;
        std::string save_filename_;
        unsigned int max_length_;
        Status status_;

        std::ofstream ofs_;
};
