//
// Logger.hpp
//

#pragma once
#include "FormatString.hpp"

class Logger {
        // Singleton
    private:
        Logger() {}
        Logger(const Logger& logger) {}
        virtual ~Logger() {}

    public:
        template<class... Params>
        static void Info(const std::string& format, Params... params) {
            getInstance().Log("INFO: ", format, params...);
        }

        template<class... Params>
        static void Error(const std::string& format, Params... params) {
            getInstance().Log("ERROR: ", format, params...);
        }

        template<class... Params>
        static void Debug(const std::string& format, Params... params) {
            getInstance().Log("DEBUG: ", format, params...);
        }

    private:
        static Logger& getInstance() {
            static Logger instance;
            return instance;
        }

        template<class... Params>
        void Log(const std::string& prefix, const std::string& format, Params... params) {
            std::cout << FormatString::New(prefix + format, params...) << std::endl;
        }
};
