//
// unicode.hpp
//

#pragma once

#include <tchar.h>
#include <string>
#include <fstream>
#include <boost/format.hpp>

typedef std::basic_string<TCHAR, std::char_traits<TCHAR>, std::allocator<TCHAR> > tstring;
typedef boost::basic_format<TCHAR> tformat;

namespace unicode {

std::string sjis2utf8(std::string);
std::string utf82sjis(std::string);

inline std::string ToString(const std::string& s)
{
    return s;
}

inline std::string ToString(const std::wstring& s)
{
    std::vector<char> mbs(s.length() * MB_CUR_MAX + 1);
    wcstombs(mbs.data(), s.c_str(), mbs.size());
    return mbs.data();
}

inline std::wstring ToWString(const std::string& s)
{
    std::vector<wchar_t> wcs(s.length() + 1);
    mbstowcs(wcs.data(), s.c_str(), wcs.size());
    return wcs.data();
}

inline std::wstring ToWString(const std::wstring& s)
{
    return s;
}

inline tstring ToTString(const std::string& s)
{
#ifdef UNICODE
    return ToWString(s);
#else
    return s;
#endif
}

inline tstring ToTString(const std::wstring& s)
{
#ifdef UNICODE
    return s;
#else
    return ToString(s);
#endif
}

} // unicode
