//
// UIList.hpp
//

#pragma once

#include "UIBase.hpp"
#include <array>
#include <string>

class UIList : public UIBase {
    public:
        UIList();
        ~UIList();
        void ProcessInput(InputManager* input);
        void Update();
        void Draw();

    public:
        static void DefineInstanceTemplate(Handle<ObjectTemplate>* object);

    private:
        std::array<int,4> scrollbar_base_image_handle_;

        std::vector<Persistent<Object>> items_;

        int scroll_y_, max_scroll_y_;
        int scrollbar_height_, scrollbar_y_;
        int drag_offset_y_;
        int item_start_, item_end_;

    private:
        void UpdateScrollBar(InputManager* input);
        void NormalizeScrollY();

    private:
        constexpr static int BASE_BLOCK_SIZE = 12;

        constexpr static int SCROLLBAR_MIN_HEIGHT = 24;

};
