//
// Main.hpp
//

#pragma once

#include <memory>
#include "Base.hpp"
#include "Accessor.hpp"
#include "../../common/network/Client.hpp"
#include "../../common/database/CardLibrary.hpp"
#include "../LoginToken.hpp"
#include "../PlayerManager.hpp"
#include "../CardManager.hpp"
#include "../CommandManager.hpp"
#include "../WorldManager.hpp"
#include "../ManagerAccessor.hpp"
#include "../ui/InputBox.hpp"

namespace scene {

class Main : public Base {

    public:
        Main(Accessor&);
        ~Main();
        virtual void Begin();
        virtual void Update();
        virtual void Draw();
        virtual void End();

    private:
        std::function<void(const tstring&)> push_message_;

    private:
        // 上位コアへのアクセサ
        Accessor& core_;

        // ログインカード
        LoginToken login_token_;

        // アクセサ
        ManagerAccessorPtr manager_accesor_;

        // プレイヤー
        PlayerManagerPtr player_manager_;

        // カード
        CardManagerPtr card_manager_;

        // コマンド
        CommandManagerPtr command_manager_;

        // 3D空間
        WorldManagerPtr world_manager_;

        // 入力ウィンドウ
        InputBox inputbox_;
};

}
