//
// Main.cpp
//

#include "Main.hpp"
#include <vector>
#include <algorithm>
#include "../3d/CharacterModelManager.hpp"

namespace scene {
Main::Main(Accessor& core)
    : core_(core),
      login_token_(_T("logincard.png")),
      manager_accesor_(std::make_shared<ManagerAccessor>()),
      player_manager_(std::make_shared<PlayerManager>(manager_accesor_)),
      card_manager_(std::make_shared<CardManager>(_T("card.db"), manager_accesor_)),
      command_manager_(std::make_shared<CommandManager>(manager_accesor_)),
      world_manager_(std::make_shared<WorldManager>(manager_accesor_)),
      inputbox_(manager_accesor_)
{
    manager_accesor_->set_card_manager(card_manager_);
    manager_accesor_->set_player_manager(player_manager_);
    manager_accesor_->set_command_manager(command_manager_);
    manager_accesor_->set_world_manager(world_manager_);

    Card::set_max_local_storage_size(core_.config().max_local_storage_size());

}

Main::~Main()
{

}

void Main::Begin()
{
    CharacterModelManager::GetInstance().AddSearchDirectoryPath(core_.config().model_dir());
    /*
    auto myself = std::make_shared<FieldPlayer>(); // TODO: クラス階層を見直す
    charmgr_->Add(0, myself);
    charmgr_->set_my_character_id(0);

    std::unique_ptr<CharacterDataProvider> char_data_provider(new CharacterDataProvider());
    auto insert_result = char_data_providers_.insert(std::make_pair(1, move(char_data_provider)));
    insert_result.first->second->set_id(1);
    insert_result.first->second->set_model(1);
    auto character = std::make_shared<PlayerCharacter>(*insert_result.first->second);
    charmgr_->Add(1, character);
    */

    card_manager_->Load();
    inputbox_.ReloadTabs();

    command_manager_->set_client(
            ClientUniqPtr(
                new network::Client(
                        core_.config().host(),
                        core_.config().port(),
                        (uint16_t)core_.config().udp_port(),
                        login_token_.public_key(),
                        login_token_.private_key(),
                        "server_key.pub",
                        core_.config().upnp()
                )
            )
    );

    player_manager_->Init();
    world_manager_->Init();

}

void Main::Update()
{
    command_manager_->Update();

    InputManager input;

    inputbox_.ProcessInput(&input);
    inputbox_.Update();

    player_manager_->ProcessInput(&input);
    player_manager_->Update();

    card_manager_->ProcessInput(&input);
    card_manager_->Update();

    input.CancelMouseLeft();

    world_manager_->ProcessInput(&input);
    world_manager_->Update();

    //        std::string binary = unicode::sjis2utf8("test");
    //        client_.Write(network::ServerReceiveChatMessage(binary));
}

void Main::Draw()
{
    world_manager_->Draw();
    player_manager_->Draw();
    card_manager_->Draw();
    inputbox_.Draw();
}

void Main::End()
{
}

}
