//
// Base.hpp
//

#pragma once

#include "DxLib.h"
#include <memory>
#include "../unicode.hpp"

namespace scene {

class Base {
    public:
        virtual ~Base();
	    virtual void Begin() = 0;
	    virtual void Update() = 0;
	    virtual void Draw() = 0;
	    virtual void End() = 0;
};

typedef std::unique_ptr<Base> BasePtr;

}
