//
// WorldManager.cpp
//

#include "WorldManager.hpp"
#include "PlayerManager.hpp"
#include "3d/Stage.hpp"

WorldManager::WorldManager(const ManagerAccessorPtr& manager_accessor) :
manager_accessor_(manager_accessor),
stage_(std::make_shared<Stage>("./model/ガレキ町１．０.x", 20.0f / 1.58f)),
game_loop_(stage_)
{

}

void WorldManager::Init()
{
    auto player_manager = manager_accessor_->player_manager().lock();
    game_loop_.Init("./model/", player_manager->charmgr());
}

void WorldManager::ProcessInput(InputManager* input)
{
    game_loop_.Logic(input);
}

void WorldManager::Update()
{

}

void WorldManager::Draw()
{
    game_loop_.Draw();
}

StagePtr WorldManager::stage()
{
    return stage_;
}
