//
// ResourceManager.cpp
//

#include "ResourceManager.hpp"

int ResourceManager::default_font_handle_ = -1;
int ResourceManager::default_font_handle()
{
    if (default_font_handle_ < 0) {
        //TCHAR font_name[] = CHAT_FONT_NAME;
        const TCHAR* font_name = CHAT_FONT_NAME;
        default_font_handle_ = CreateFontToHandle(font_name, CHAT_FONT_SIZE, CHAT_FONT_THICK, CHAT_FONT_TYPE);
    }

    return default_font_handle_;

}

int ResourceManager::default_font_size()
{
    return CHAT_FONT_SIZE;
}

std::unordered_map<std::string, int> ResourceManager::graph_handles_;
std::unordered_map<std::string, std::vector<int>> ResourceManager::div_graph_handles_;
int ResourceManager::LoadCachedGraph(const std::string& filename)
{
    int handle;
    if(graph_handles_.find(filename) == graph_handles_.end()) {
        if((handle = DxLib::LoadGraph(filename.c_str())) < 0){
            return -1;
        }
        graph_handles_[filename] = handle;
    } else {
        handle = graph_handles_[filename];
    }
    return handle;
}

void ResourceManager::ClearCache()
{
    for (auto handle : graph_handles_) {
        DeleteGraph(handle.second);
    }
    graph_handles_.clear();

    for (auto handles : div_graph_handles_) {
        for (auto handle : handles.second) {
            DeleteGraph(handle);
        }
    }
    div_graph_handles_.clear();
}
