//
// ManagerAccessor.cpp
//

#include "ManagerAccessor.hpp"

ManagerAccessor::ManagerAccessor(const CardManagerWeakPtr& card_manager,
        const PlayerManagerWeakPtr& player_manager) :
card_manager_(card_manager),
player_manager_(player_manager)
{

}

ManagerAccessor::ManagerAccessor()
{

}

const CardManagerWeakPtr& ManagerAccessor::card_manager()
{
    return card_manager_;
}

void ManagerAccessor::set_card_manager(CardManagerWeakPtr card_manager)
{
    card_manager_ = card_manager;
}

const PlayerManagerWeakPtr& ManagerAccessor::player_manager()
{
    return player_manager_;
}

void ManagerAccessor::set_player_manager(PlayerManagerWeakPtr player_manager)
{
    player_manager_ = player_manager;
}

const CommandManagerWeakPtr& ManagerAccessor::command_manager()
{
    return command_manager_;
}

void ManagerAccessor::set_command_manager(CommandManagerWeakPtr command_manager)
{
    command_manager_ = command_manager;
}

const WorldManagerWeakPtr& ManagerAccessor::world_manager()
{
    return world_manager_;
}

void ManagerAccessor::set_world_manager(WorldManagerWeakPtr world_manager)
{
    world_manager_ = world_manager;
}
