#pragma once

#include <memory>
#include "Character.hpp"
#include "CharacterDataProvider.hpp"
#include "Timer.hpp"
#include "Stage.hpp"

// 他人のキャラ
class PlayerCharacter : public Character
{
public:
    PlayerCharacter(CharacterDataProvider& data_provider, const StagePtr& stage, const TimerPtr& timer);
    virtual ~PlayerCharacter();

    void Draw() const;
    void Update();

private:
    class Impl;
    std::unique_ptr<Impl> impl_;
};
