class _tl_node;
class _node;
class _subnode;
class _columns;
class subcolumn;
class _tl_node_manager;

class _subnode
{
public:
	string				m_strText;
	bool				m_bCheckable;
	DWORD				m_dwStyle;
};
class _node
{
	map<int,_subnode>	m_subnode;
	_tl_node			*m_tl_node;
	int					m_height;
	bool				m_selected;
	DWORD				m_dwStyle;
public:
	_node( _tl_node *node )
	{
		m_tl_node = NULL;
		m_height = 0;
		m_selected = false;
		m_dwStyle = 0;
	}
	_subnode *get_subnode( int index )
	{
		map<int,_subnode>::iterator it = m_subnode.find( index );
		if( it == m_subnode.end() )
			return NULL;
		else
			return &it->second;
	}
};
class _subcolumn
{
public:
	int					m_width;
	string				m_name;
	DWORD				m_dwStyle;
};
class _columns
{
	_tl_node_manager	*m_tl_manager;
	vector<_subcolumn>	m_vSubColumn;
	DWORD				m_dwStyle;

public:
	_columns( _tl_node_manager *p_manager )
	{
		m_tl_manager = p_manager;
		m_dwStyle = 0;
	}

	void add_column( int width, DWORD dwStyle )
	{
		_subcolumn column;
		column.m_width = width;
		column.m_dwStyle = dwStyle;
		m_vSubColumn.push_back( column );
	}

	unsigned int get_column_size( )
	{
		return m_vSubColumn.size();
	}

	_subcolumn *get_column( unsigned int index )
	{
		return &m_vSubColumn[index];
	}
};

class _tl_node
{
	_tl_node_manager	*m_tl_manager;
	_tl_node			*m_pPrev;
	_tl_node			*m_pNext;
	_tl_node			*m_pChild;
	_tl_node			*m_parent;
	_node				*m_pObj;
	bool				m_bExpand;
	bool				m_bNotHasChild;
public:
	_tl_node( _tl_node_manager *p_manager )
	{
		m_tl_manager = p_manager;
		m_pObj = new _node( this );
		m_pPrev = NULL;
		m_pNext = NULL;
		m_pChild = NULL;
		m_parent =NULL;
		m_bExpand = FALSE;
		m_bNotHasChild = FALSE;
	}

	~_tl_node()
	{
		if( m_pPrev )
			m_pPrev->m_pNext = m_pNext;
		if( m_pNext )
			m_pNext->m_pPrev = m_pPrev;
		if( m_pChild )
		{
			_tl_node *pChild = m_pChild;
			while( pChild )
			{
				_tl_node *pChildNext = pChild = pChild->m_pNext;
				delete pChild;
				pChild = pChildNext;
			}
		}
		if( m_parent )
		{
			_tl_node *pChild = m_parent->m_pChild;
			while( pChild != this )
				pChild = pChild->m_pNext;
			if( pChild->m_pPrev )
				pChild->m_pPrev->m_pNext = pChild->m_pNext;
			if( pChild->m_pNext )
				pChild->m_pNext->m_pPrev = pChild->m_pPrev;
		}
	}

	void insert_after( _tl_node *pnode )
	{
		_tl_node *pNextOrg = m_pNext;
		m_pNext = pnode;
		pnode->m_pPrev =this;
		pnode->m_pNext = pNextOrg;
		if( pNextOrg )
			pNextOrg->m_pPrev = pnode;
	}
	void insert_before( _tl_node *pnode )
	{
		_tl_node *pBeforeOrg = m_pPrev;
		m_pPrev = pnode;
		pnode->m_pNext = this;
		pnode->m_pPrev = pBeforeOrg;
		if( pBeforeOrg )
			pBeforeOrg->m_pNext = pnode;
	}
	void remove( )
	{
		delete this;
	}
	void insert_child( _tl_node *pnode )
	{
		_tl_node *pChild = m_pChild;
		pChild->m_parent =this;
		if( !pChild )
		{
			m_pChild = pnode;
		}
		else
		{
			while( pChild->m_pNext )
			{
				pChild = pChild->m_pNext;
			}
			pChild->m_pNext = pnode;
			pnode->m_pPrev = pChild;
		}
	}
	_node *get_node()
	{
		return m_pObj;
	}
	_tl_node *get_next( )
	{
		return m_pNext;
	}
	_tl_node *get_prev( )
	{
		return m_pPrev;
	}
	_tl_node *get_child( )
	{
		return m_pChild;
	}
	_tl_node *get_parent( )
	{
		return m_parent;
	}
};
class _tl_node_manager
{
	_tl_node			*m_root;
	_columns			*m_column_info;
public:
	_tl_node_manager()
	{
		m_root = NULL;
		m_column_info =new _columns( this );
	}

	bool _node_create_root()
	{
		if	(m_root )
			return false;
		m_root = new _tl_node( this );
		return true;
	}
	_tl_node *get_root_node()
	{
		return m_root;
	}
	_columns *get_columns()
	{
		return m_column_info;
	}

	_tl_node *create_node( )
	{
		return new _tl_node( this );
	}
};
class _dump_tl_node_object
{
	_tl_node_manager	*m_p_manager;
public:
	_dump_tl_node_object( _tl_node_manager *p_manager )
	{
		m_p_manager = p_manager;
	}

	void dump( iostream &out )
	{
		dump_column( out );
		dump_nodes( out, m_p_manager->get_root_node(), 0 );
	}

	void dump_column( iostream &out )
	{
		_columns *p_columns = m_p_manager->get_columns( );
		unsigned int n_size = p_columns->get_column_size();
		out << "[column]" << endl;
		for( unsigned int cnt = 0; cnt < n_size; cnt ++ )
		{
			_subcolumn *pcolumn = p_columns->get_column( cnt );
			out << pcolumn->m_name << '\t';
		}
		out << endl;
	}

	void dump_nodes( iostream &out, _tl_node *node, unsigned int rank )
	{
		_node *p_node = node->get_node();
		int size = m_p_manager->get_columns()->get_column_size();
		for( int rankcnt = 0; rankcnt < rank; rankcnt ++ )
			out << ' ';
		for( int cnt =0; cnt < size; cnt ++ )
		{
			_subnode *psubnode = p_node->get_subnode( cnt );
			out << psubnode->m_strText;
		}
		out << endl;
		if( node->get_child() )
			dump_nodes( out, node->get_child(), rank + 1 );
		if( node->get_next() )
			dump_nodes( out, node->get_next(), rank );
	}
};