#pragma once
#include <windows.h>

#undef _EXPORT_
#ifdef PIC_KERNEL_EXPORTS
#define _EXPORT_ __declspec(dllexport) 
#else
#define _EXPORT_ __declspec(dllimport) 
#endif

class _EXPORT_ CPLImage
{
public:
	CPLImage(void);
	virtual ~CPLImage(void);

	static CPLImage * __fastcall Create( );
	static void __fastcall Destroy( CPLImage *hImage );

	// 
	virtual bool __fastcall CreateImage( TCHAR *strImageName ) ;
	virtual bool __fastcall CreateImage( TCHAR *strImageName, int width, int height, int colordepth );
	virtual bool __fastcall RenewalImage( int width, int height, int colordepth );
	virtual CPLImage * __fastcall Clone( TCHAR *strNewImageName ) = 0;
	virtual bool HasObject( ) = 0;

	// j
	virtual void __fastcall DestroyImage( ) = 0;

	// 
	virtual bool __fastcall Copy( CPLImage &out );

	// 擾
	virtual bool __fastcall GetObjectName( TCHAR *strResult, int nLength );
	virtual bool __fastcall GetImageSize( int &width, int &heihgt );
	virtual bool __fastcall GetImageColorDepth( int &colordepth );
	virtual bool __fastcall GetImagePalette( int nIndex, COLORREF &crPalette );
	virtual bool __fastcall GetImagePixel( int width, int heihgt, COLORREF &crResult ) = 0;
	virtual bool __fastcall GetImagePixel( int width, int height, unsigned char &paletteIndex ) = 0;
	virtual bool __fastcall GetImageLine( int nLine, unsigned char **pResult, BOOL bPaletteIndex ) = 0;
	virtual bool __fastcall GetImageLine( int nLine, const unsigned char ** const pResult, BOOL bPaletteIndex ){ return GetImageLine( nLine, (unsigned char **)pResult, bPaletteIndex ); }
	virtual bool __fastcall GetBlock(int nLeft, int nTop, int nWidth, int nHeight, CPLImage *pResult);

	// ݒ
	virtual bool __fastcall SetImagePalette( int nIndex, COLORREF crPalette );
	virtual bool __fastcall SetImagePixel( int width, int height, COLORREF crPixel ) = 0;
	virtual bool __fastcall SetImagePixel( int width, int height, unsigned char paletteNo ) = 0;
	virtual bool __fastcall SetImageLine( int nLine, unsigned char *pLineData ) = 0;

	// AANZX̂߂Ƀf[^œK
	virtual bool __fastcall BeginAccessLines( int nStartLine, int nEndLine ){return false;}
	virtual bool __fastcall EndAccessLines( ){return false;}

protected:
	TCHAR m_ObjectName[MAX_PATH];

	virtual void __fastcall init( );

	int m_Width;
	int m_Height;
	int m_ColorDepth;
	COLORREF m_Palette[256];

};
