#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <stdio.h>

#include "../hed/hed_picturelib/plimage.h"
#include "../hed/hed_picturelib/pldata.h"
#include "../hed/hed_picturelib/memorydata.h"
#include "../hed/hed_picturelib/filedata.h"

// VER 0.0.1	Ƃ肠
// VER 0.0.2	attach_memory_image API ̒ǉ
//				8 bit  BITMAP ɑΉ
// VER 0.0.3	4 bit  BITMAP ɑΉ
// VER 0.0.3	I/F̕ύX

/***************************************************************
BITMAP t@C ǂݍ݁Aǂݍ񂾉摜 image_handle Ԃ
Ή` 8bit/24bit k Windows ` BITMAP

strFile	: ǂݍރt@C
߂l
ǂݍ񂾉摜̃C[Wnh
s NULLԂ
***************************************************************/
bool __stdcall read_image( const TCHAR *strFile, CPLImage &hImageResult )
{
	if( !strFile || strFile[0] == _T('\0') )
		return false;
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	bool bRetVal = false;

	FILE *in = _tfopen( strFile, _T("rb") );
	if( !in ) 
		return false;
	
	do
	{
		// Header ̓ǂݍ
		if( !fread( &bmfh, sizeof( BITMAPFILEHEADER ), 1, in ) ||
			!fread( &bmih, sizeof( BITMAPINFOHEADER ), 1, in ) )
			break;

		// ImageObject̐
		bool bResult = false;
		if( bmih.biBitCount * bmih.biPlanes < 8 )
			bResult = hImageResult.RenewalImage( bmih.biWidth, bmih.biHeight, 8 );
		else
			bResult = hImageResult.RenewalImage( bmih.biWidth, bmih.biHeight, bmih.biBitCount * bmih.biPlanes );
		if( !bResult )
			break;

		if( bmih.biBitCount * bmih.biPlanes != 1 &&
			bmih.biBitCount * bmih.biPlanes != 4 &&
			bmih.biBitCount * bmih.biPlanes != 8 &&
			bmih.biBitCount * bmih.biPlanes != 24 )
			break;

		// pbgGg[̓ǂݍ
		switch( bmih.biBitCount * bmih.biPlanes )
		{
		case 1:
		case 4:
		case 8:
			{
				int nPalette = 0;
				if( bmih.biBitCount * bmih.biPlanes == 1 )
					nPalette = ( bmih.biClrUsed == 0 ) ? 2 : bmih.biClrUsed;
				else if( bmih.biBitCount * bmih.biPlanes == 4 )
					nPalette = ( bmih.biClrUsed == 0 ) ? 16 : bmih.biClrUsed;
				else
					nPalette = ( bmih.biClrUsed == 0 ) ? 256 : bmih.biClrUsed;
				RGBQUAD *pRGB = new RGBQUAD[nPalette];
				fread( pRGB, sizeof(RGBQUAD) * nPalette, 1, in );
				for( int cur = 0; cur < nPalette; cur ++ )
				{
					COLORREF color = RGB( pRGB[cur].rgbRed, pRGB[cur].rgbGreen, pRGB[cur].rgbBlue );
					hImageResult.SetImagePalette( cur, color );
				}
				delete [] pRGB;
			}
			break;
		case 24:
			break;
		default:
			hImageResult.DestroyImage( );
		}

		// Bit̓ǂݍ
		unsigned long lBitData = bmfh.bfOffBits;

		hImageResult.BeginAccessLines( 0, bmih.biHeight - 1 );
		switch( bmih.biBitCount * bmih.biPlanes )
		{
		case 1:
			{
				int height = bmih.biHeight;
				int width = bmih.biWidth;
				int width2 = ( ( ( bmih.biWidth + 7 ) & ~3 ) / 8 + 3 ) & ~3;
				unsigned char *pPixels = new unsigned char[width2];
				unsigned char *pWrite = new unsigned char[width];
				for( int i = 0; i < height; i ++ )
				{
					fseek( in, lBitData + ( height - i - 1 ) * width2, SEEK_SET );
					fread( pPixels, width2, 1, in );
					for( int j = 0; j < width; j ++ )
					{
						if ( pPixels[j / 8] & ( 1 << ( 8 - ( j % 8 ) ) ) )
							pWrite[j] = 1;
						else
							pWrite[j] = 0;
					}
					hImageResult.SetImageLine( i, pWrite );
				}
				delete [] pWrite;
				delete [] pPixels;
			}
			break;
		case 4:
			{
				int height = bmih.biHeight;
				int width = bmih.biWidth;
				int width2 = ( ( width + 1 ) / 2 + 3 ) & ~3;
				unsigned char *pBitData = new unsigned char [ width2 ];
				memset( pBitData, 0x00, width2 );
				for( int i = 0; i < height; i ++ )
				{
					fseek( in, lBitData + width2 * ( height - i - 1 ), SEEK_SET );
					fread( pBitData, width2, 1, in );
					for( int j = 0; j < width; j ++ )
					{
						COLORREF crBits = RGB( 0, 0, 0 );
						unsigned char bits = pBitData[ j / 2];
						if( !(j % 2) )
						{
							crBits = bits >> 4;
						}
						else
						{
							crBits = bits & 0x0f;
						}
						hImageResult.SetImagePixel( j, i, (unsigned char)crBits );
					}
				}
				delete [] pBitData;
			}
			break;
		case 8:
			{
				int height = bmih.biHeight;
				int width = bmih.biWidth;
				int width2 = ( bmih.biWidth + 3 ) & ~3;
				unsigned char *pPixels = new unsigned char[width2];
				unsigned char *pWrite = new unsigned char[width];
				for( int i = 0; i < height; i ++ )
				{
					fseek( in, lBitData + ( height - i - 1 ) * width2, SEEK_SET );
					fread( pPixels, width, 1, in );
					for( int j = 0; j < width; j ++ )
					{
						pWrite[j] = pPixels[j];
					}
					hImageResult.SetImageLine( i, pWrite );
				}
				delete [] pWrite;
				delete [] pPixels;
			}
			break;
		case 24:
			{
				int height = bmih.biHeight;
				int width = bmih.biWidth;
				int width2 = ( width * 3 + 3 ) & ~3;
				unsigned char *tmpBitData = new unsigned char[width2];
				COLORREF *pWrite = new COLORREF[width];
				for( int i = 0; i < height; i ++ )
				{
					unsigned char *pIn = tmpBitData;
					fseek( in, lBitData + ( height - i - 1 ) * width2, SEEK_SET );
					fread( tmpBitData, width2, 1, in );
					for( int j = 0; j < width; j++ )
					{
						pWrite[j] = RGB( *(pIn+2), *(pIn+1), *pIn );
						pIn+=3;
					}
					hImageResult.SetImageLine( i, (unsigned char *)pWrite );
				}
				delete[] pWrite;
				delete[] tmpBitData;
			}
		}
		hImageResult.EndAccessLines( );
		bRetVal = true;
	}while( false );
	fclose( in );
	return bRetVal;
}

bool __stdcall get_bmp_data( const TCHAR *strFile, CPLMemoryData &pBitmap )
{
	CPLFileData *file = CPLFileData::create( strFile );
	if( file == NULL )
		return false;

	CPLMemoryData *pTarget = file->read_data( );
	bool result = false;
	if( pTarget != NULL )
	{
		pBitmap.attach( pTarget->get_handle(), pTarget->get_type() );
		pTarget->detach();
		CPLMemoryData::destroy( pTarget );
		result = true;
	}
	file->detach();
	CPLFileData::destroy( file );
	return result;
}

/***************************************************************
nꂽf[^ΉĂC[Wł邩ׂ
Ή` 1bit/4bit/8bit/24bit k Windows ` BITMAP

pData : CPLDatapbNꂽf[^IuWFNg
߂l
ΉĂ`̃t@Cłtrue, łȂfalse
***************************************************************/
bool __stdcall is_supported_image( CPLData *pData )
{
	if( !pData )
		return false;
	
	CPLMemoryData *pMemoryData = NULL;
	bool bDestroy = false;
	if( pData->is_file() )
	{
		CPLFileData *pFile = pData->get_file();
		pMemoryData = pFile->read_data( sizeof( BITMAPFILEHEADER ) + sizeof( BITMAPINFOHEADER ) );
		bDestroy = true;
	}
	else if( pData->is_memory() )
	{
		pMemoryData = pData->get_memory();
	}
	if( !pMemoryData )
		return false;
	
	bool bResult = false;
	do
	{
		if( pMemoryData->get_size() < sizeof( BITMAPFILEHEADER ) + sizeof( BITMAPINFOHEADER ) )
			break;
		char *pRawData = (char*)pMemoryData->get_ptr();
		BITMAPFILEHEADER *pbmf = (BITMAPFILEHEADER*)pRawData;
		BITMAPINFOHEADER *pbih = (BITMAPINFOHEADER*)(pRawData + sizeof(BITMAPFILEHEADER) );
		if( pbmf->bfType != 0x4d42 )
			break;
		if( pbmf->bfReserved1 != 0 )
			break;
		if( pbmf->bfReserved2 != 0 )
			break;
		if( pbmf->bfOffBits == 0 )
			break;
		if( pbih->biSize != sizeof( BITMAPINFOHEADER ) )
			break;
		if( pbih->biBitCount != 1 &&
			pbih->biBitCount != 4 &&
			pbih->biBitCount != 8 &&
			pbih->biBitCount != 24 )
			break;
		if( pbih->biPlanes != 1 )
			break;
		if( pbih->biWidth == 0 ||
			pbih->biHeight == 0 )
			break;
		if( pbih->biClrUsed > (DWORD)( 1 << pbih->biBitCount ) )
			break;
		if( pbih->biCompression != BI_RGB )
			break;
		bResult = true;
	}while( false );
	if( bDestroy )
		CPLMemoryData::destroy( pMemoryData );
	return bResult;
}

/***************************************************************
C[W̕AAF[x擾
Ή` 1bit/4bit/8bit/24bit k Windows ` BITMAP

pData : CPLDatapbNꂽf[^IuWFNg
width, height, colordepth : 摜
߂l
ΉĂ`̃t@Cłtrue, łȂfalse
***************************************************************/
bool __stdcall get_image_info( CPLData *pData, int &width, int &height, int &colordepth )
{
	if( !pData )
		return false;
	CPLMemoryData *pMemoryData = NULL;
	bool bDestroy = false;
	if( pData->is_file() )
	{
		CPLFileData *pFile = pData->get_file();
		pMemoryData = pFile->read_data( sizeof( BITMAPFILEHEADER ) + sizeof( BITMAPINFOHEADER ) );
		bDestroy = true;
	}
	if( !pMemoryData )
		return false;
	
	bool bResult = false;
	do
	{
		if( pMemoryData->get_size() < sizeof( BITMAPFILEHEADER ) + sizeof( BITMAPINFOHEADER ) )
			break;
		char *pRawData = (char*)pMemoryData->get_ptr();
		BITMAPFILEHEADER *pbmf = (BITMAPFILEHEADER*)pRawData;
		BITMAPINFOHEADER *pbih = (BITMAPINFOHEADER*)(pRawData + sizeof(BITMAPFILEHEADER) );
		width = pbih->biWidth;
		height = pbih->biHeight;
		colordepth = pbih->biBitCount;
		bResult = true;
	}while( false );

	if( bDestroy )
		CPLMemoryData::destroy( pMemoryData );
	return bResult;
}

/***************************************************************
BITMAP Image ̃[ image_handle 𐶐
Ή` 4Bit/8bit/24bit k Windows ` BITMAP

pHeader		: HEADER ւ̃AhX
pBits		: Bit ւ̃AhX
߂l
ǂݍ񂾉摜̃C[Wnh
s NULLԂ
***************************************************************/
bool __stdcall attach_memory_image( const void *pHeader, const void *pBits, CPLImage &hImageResult )
{
	BITMAPINFO *pBMI = (BITMAPINFO*)pHeader;
	unsigned char *pBitData = (unsigned char *)pBits;
	if( !pBMI || !pBitData )
		return false;
	BITMAPINFOHEADER &bmih = pBMI->bmiHeader;
	RGBQUAD *prgbPalette = pBMI->bmiColors;

	bool bRetVal = false;	
	do
	{
		// ImageObject̐
		bool bResult = false;
		if( bmih.biBitCount * bmih.biPlanes < 8 )
			bResult = hImageResult.RenewalImage( bmih.biWidth, bmih.biHeight, 8 );
		else
			bResult = hImageResult.RenewalImage( bmih.biWidth, bmih.biHeight, 24 );
		if( !bResult )
			break;
		// pbgGg[̓ǂݍ
		switch( bmih.biBitCount * bmih.biPlanes )
		{
		case 1:
		case 4:
		case 8:
			{
				int nPalette = 0;
				if( bmih.biBitCount * bmih.biPlanes == 1 )
					nPalette = ( bmih.biClrUsed == 0 ) ? 2 : bmih.biClrUsed;
				else if( bmih.biBitCount * bmih.biPlanes == 4 )
					nPalette = ( bmih.biClrUsed == 0 ) ? 16 : bmih.biClrUsed;
				else
					nPalette = ( bmih.biClrUsed == 0 ) ? 256 : bmih.biClrUsed;
				for( int cur = 0; cur < nPalette; cur ++ )
				{
					RGBQUAD *pRGB = &(prgbPalette[cur]);
					COLORREF color = RGB( pRGB->rgbRed, pRGB->rgbGreen, pRGB->rgbBlue );
					hImageResult.SetImagePalette( cur, color );
				}
			}
			break;
		case 24:
		case 32:
			break;
		default:
			hImageResult.DestroyImage( );
		}
		if( bmih.biBitCount * bmih.biPlanes != 1 &&
			bmih.biBitCount * bmih.biPlanes != 4 &&
			bmih.biBitCount * bmih.biPlanes != 8 &&
			bmih.biBitCount * bmih.biPlanes != 24 &&
			bmih.biBitCount * bmih.biPlanes != 32 )
			break;

		// Bit̓ǂݍ
		switch( bmih.biBitCount * bmih.biPlanes )
		{
		case 1:
			{
				int height = bmih.biHeight;
				int width = bmih.biWidth;
				int width2 = ( ( width + 1 ) / 8 + 3 ) & ~3;
				for( int i = 0; i < height; i ++ )
				{
					for( int j = 0; j < width; j ++ )
					{
						COLORREF crBits = RGB( 0, 0, 0 );
						unsigned char bits = ( pBitData[width2 * ( height - i - 1 ) + j / 8] & ( 1 << ( j % 8 ) ) ) ? 1 : 0;
						hImageResult.SetImagePixel( j, i, crBits );
					}
				}
			}
			break;
		case 4:
			{
				int height = bmih.biHeight;
				int width = bmih.biWidth;
				int width2 = ( ( width + 1 ) / 2 + 3 ) & ~3;
				for( int i = 0; i < height; i ++ )
				{
					for( int j = 0; j < width; j ++ )
					{
						COLORREF crBits = RGB( 0, 0, 0 );
						unsigned char bits = pBitData[width2 * ( height - i - 1 ) + j / 2];
						if( !(j % 2) )
						{
							crBits = bits >> 4;
						}
						else
						{
							crBits = bits & 0x0f;
						}
						hImageResult.SetImagePixel( j, i, crBits );
					}
				}
			}
			break;
		case 8:
			{
				int height = bmih.biHeight;
				int width = bmih.biWidth;
				int width2 = ( bmih.biWidth + 3 ) & ~3;
				unsigned char *pBufWrite = new unsigned char[width];
				for( int i = 0; i < height; i ++ )
				{
					for( int j = 0; j < width; j ++ )
					{
						pBufWrite[j] = pBitData[(height-i-1)*width2 + j];
					}
					hImageResult.SetImageLine( i, pBufWrite );
				}
				delete[] pBufWrite;
			}
			break;
		case 24:
			{
				int height = bmih.biHeight;
				int width = bmih.biWidth;
				int width2 = ( width * 3 + 3 ) & ~3;
				unsigned char *tmpBitData = new unsigned char[width2];
				COLORREF *pBufWrite = new COLORREF[width];
				for( int i = 0; i < height; i ++ )
				{
					unsigned char *pIn = tmpBitData;
					memcpy( tmpBitData, &pBitData[(height - i - 1 ) * width2], width*3 );
					for( int j = 0; j < width; j++ )
					{
						pBufWrite[j] = RGB( *(pIn+2), *(pIn+1), *pIn );
						pIn+=3;
					}
					hImageResult.SetImageLine( i, (unsigned char*)pBufWrite );
				}
				delete[] tmpBitData;
				delete[] pBufWrite;
			}
		case 32:
			{
				int height = bmih.biHeight;
				int width = bmih.biWidth;
				int width2 = width * 4;
				unsigned char *tmpBitData = new unsigned char[width2];
				COLORREF *pBufWrite = new COLORREF[width];
				for( int i = 0; i < height; i ++ )
				{
					unsigned char *pIn = tmpBitData;
					memcpy( tmpBitData, &pBitData[(height - i - 1 ) * width2], width2 );
					for( int j = 0; j < width; j++ )
					{
						pBufWrite[j] = RGB( *(pIn+2), *(pIn+1), *pIn );
						pIn+=4;
					}
					hImageResult.SetImageLine( i, (unsigned char*)pBufWrite );
				}
				delete[] tmpBitData;
				delete[] pBufWrite;
			}

		}
		bRetVal = true;
	}while( false );
	return bRetVal;
}